#include "dgp0.hh"
#include "global.hh"

extern Grammar grammar;
extern MGraph mgraph;
extern SGraph sgraph;

extern bool debug;

list<int> nodelist;
list<int>::iterator processed;


void set_initial_constraints(int node)
{
  sgraph[node].prop.forbidden.reset();
  sgraph[node].prop.required=grammar.is_obl(mgraph[sgraph[node].mnode].cat);
}


bool changing_constraints(int head, Role role)
{
  return grammar.is_sgl(role) || sgraph[head].prop.required[role];
}

void apply_constraints(int head, Role role)
{
  if(grammar.is_sgl(role)) sgraph[head].prop.forbidden.set(role);
  sgraph[head].prop.required.reset(role);
}

NodeProp compute_prop_left(NodeProp headprop, Role role)
{
  NodeProp ret=headprop;
  if(grammar.is_sgl(role)) ret.forbidden.set(role);
  ret.required.reset(role);
  return ret;
}

NodeProp compute_prop_right(NodeProp headprop, Role role)
{
  NodeProp ret=headprop;

  if(grammar.is_sgl(role)) ret.forbidden.set(role);
  ret.required.reset(role);
  return ret;
}

int get_node(MNode& mnode, NodeProp p, bitset<MAXNODES>& newheadLH, bitset<MAXNODES>& newheadLV)
{
  for(vector<int>::iterator ps=mnode.snodes.begin(); ps!=mnode.snodes.end(); ++ps)
    if(sgraph[*ps].prop==p && sgraph[*ps].LH==newheadLH && sgraph[*ps].LV==newheadLV)
      return *ps;
  return -1;
}

void connect_left(list<int>::iterator h, list<int>::iterator d, Role r)
{
  NodeProp &oldheadprop = sgraph[*h].prop;
  NodeProp newheadprop  = compute_prop_left(oldheadprop,r);
  
  int newheadind;
  if(oldheadprop==newheadprop)
    newheadind = *h;
  else
  {
    bitset<MAXNODES> newheadLH = sgraph[*h].LH;
    bitset<MAXNODES> newheadLV = sgraph[*d].LV;
    bitset<MAXNODES> newheadLD = sgraph[*h].LD;

    newheadind = get_node(mgraph[sgraph[*h].mnode], newheadprop, newheadLH, newheadLV);
    if( newheadind < 0 )
    {
      newheadind = sgraph.clone(*h,newheadprop);
      list<int>::iterator nextit=h; ++nextit;
      nodelist.insert(nextit,newheadind);
      sgraph[newheadind].LH=newheadLH;
      sgraph[newheadind].LD = newheadLD;
      sgraph[newheadind].in_LH=true;
      sgraph[newheadind].LV.reset();
      
      if(debug) sgraph.print_node_debug(stderr," C ",newheadind);
    }
    else
      sgraph[newheadind].LD |= newheadLD; // TYLKO DLA LD
  }

  sgraph[newheadind].deps.push_back(Arc(*d,r,*h));
  
  if(sgraph[*d].saturated()) sgraph[newheadind].LV |= sgraph[*d].LV;

  sgraph[newheadind].LD.set(*d);
  if(sgraph[*d].saturated()) sgraph[newheadind].LD |= sgraph[*d].LD;
  
  if(debug) sgraph.print_arc(stderr,*d,newheadind,r,0), sgraph.print_node_debug(stderr," U ",newheadind);
}

void connect_right(list<int>::iterator h, list<int>::iterator d, Role r)
{
  NodeProp &oldheadprop = sgraph[*h].prop;
  NodeProp newheadprop = compute_prop_right(oldheadprop,r);
  int newheadind;
  
  if(oldheadprop==newheadprop)
    newheadind = *h;
  else
  {
    bitset<MAXNODES> newheadLH = sgraph[*h].LH;
    bitset<MAXNODES> newheadLV = sgraph[*h].LV;
    bitset<MAXNODES> newheadLD = sgraph[*h].LD;

    newheadind = get_node(mgraph[sgraph[*h].mnode], newheadprop, newheadLH, newheadLV);
    if( newheadind < 0 )
    {
      newheadind = sgraph.clone(*h,newheadprop);
      list<int>::iterator nextit=h; ++nextit;
      nodelist.insert(nextit,newheadind);
      sgraph[newheadind].LH=newheadLH;
      sgraph[newheadind].LD=newheadLD;
      sgraph[newheadind].in_LH=false;
      sgraph[newheadind].LV=newheadLV;
      
      if(debug) sgraph.print_node_debug(stderr," C ",newheadind);
    }
    else
      sgraph[newheadind].LD |= newheadLD; // TYLKO DLA LD
  }
  
  sgraph[*d].heads.push_back(Arc(newheadind,r,*h));

  sgraph[*d].LH.set(newheadind);

  if(sgraph[newheadind].saturated()) sgraph[*d].LH |= sgraph[newheadind].LH;

  if(debug) sgraph.print_arc(stderr,newheadind,*d,r,1), sgraph.print_node_debug(stderr," U ",*d);
  
}


void try_connect_dependents(list<int>::iterator j)
{
  for(list<int>::iterator i(j); i!=nodelist.begin(); --i)
    if(sgraph.visible(*i,*j) && sgraph.saturated(*i))
    {
      Roles& ji_roles = grammar.connectable( mgraph[sgraph[*j].mnode].cat, mgraph[sgraph[*i].mnode].cat );
      for(RolesIter r=ji_roles.begin(); r!=ji_roles.end();++r)
        if(grammar.check_constr(sgraph[*j].prop,sgraph[*i].prop,0,*r))
          connect_left(j,i,*r);
    }
}


void try_connect_heads(list<int>::iterator j)
{
  for(list<int>::iterator i(j); i!=nodelist.begin(); --i)
    if(sgraph.visible(*i,*j))
    {
      Roles& ij_roles = grammar.connectable( mgraph[sgraph[*i].mnode].cat, mgraph[sgraph[*j].mnode].cat );
      for(RolesIter r=ij_roles.begin(); r!=ij_roles.end();++r)
        if(grammar.check_constr(sgraph[*i].prop,sgraph[*j].prop,1,*r))
          connect_right(i,j,*r);
    }
}


void reverse_links()
{
  list<int>::iterator i = nodelist.begin();
  for(++i; i!=nodelist.end(); ++i)
    {
      for(vector<Arc>::iterator da=sgraph[*i].deps.begin()--; da!=sgraph[*i].deps.end(); ++da)
        sgraph[da->dst].heads.push_back(Arc(*i,da->role,da->anc));
      for(vector<Arc>::iterator ha=sgraph[*i].heads.begin(); ha!=sgraph[*i].heads.end(); ++ha)
        sgraph[ha->dst].deps.push_back(Arc(*i,ha->role,ha->anc));
    }
}


void dgp0()
{

  nodelist.clear();
  nodelist.push_back(0); // BOS
  processed=nodelist.begin();

  for(int m=0; m<mgraph.size() ; ++m)
  {
    int basenode = sgraph.add_base_snode(m); // ma zwraca SNode*

    set_initial_constraints(basenode);
    nodelist.push_back(basenode);

    if(debug) {sgraph.print_node_debug(stderr,"B  ",basenode);} // STDOUT!!!

    list<int>::iterator cursor=processed;
    while(++cursor != nodelist.end())
    {
      try_connect_dependents(cursor);
      try_connect_heads(cursor);
      processed=cursor;
    }

  }
  reverse_links();
}
