#include "dgp0.hh"
#include "global.hh"

extern Grammar grammar;
extern MGraph mgraph;
extern SGraph sgraph;

SNode* snodes;

extern bool debug;

list<int> nodelist;
list<int>::iterator processed;


void set_initial_constraints(int node)
{
  snodes[node].prop.forbidden.reset();
  snodes[node].prop.required=grammar.obl[snodes[node].mnode->cat];
}


bool changing_constraints(int head, Role role)
{
  return grammar.sgl[role] || snodes[head].prop.required[role];
}

void apply_constraints(int head, Role role)
{
  if(grammar.sgl[role]) snodes[head].prop.forbidden.set(role);
  snodes[head].prop.required.reset(role);
}

NodeProp compute_prop_left(NodeProp headprop, Role role)
{
  NodeProp ret=headprop;
  if(grammar.sgl[role]) ret.forbidden.set(role);
  ret.required.reset(role);
  return ret;
}

NodeProp compute_prop_right(NodeProp headprop, Role role)
{
  NodeProp ret=headprop;

  if(grammar.sgl[role]) ret.forbidden.set(role);
  ret.required.reset(role);
  return ret;
}

int get_node(MNode& mnode, NodeProp p, bitset<MAXNODES>& newheadLH, bitset<MAXNODES>& newheadLV)
{
  for(vector<int>::iterator ps=mnode.snodes.begin(); ps!=mnode.snodes.end(); ++ps)
    if(snodes[*ps].prop==p && snodes[*ps].LH==newheadLH && snodes[*ps].LV==newheadLV)
      return *ps;
  return -1;
}

void connect_left(list<int>::iterator h, list<int>::iterator d, Role r)
{
  NodeProp &oldheadprop = snodes[*h].prop;
  NodeProp newheadprop;
  bitset<MAXNODES> newheadLV;
  bitset<MAXNODES> newheadLH;
  bitset<MAXNODES> newheadLD;
  
  newheadprop=compute_prop_left(oldheadprop,r);
  
  int newheadind;
  if(oldheadprop==newheadprop)
    newheadind = *h;
  else
  {
    newheadLH = snodes[*h].LH;
    newheadLV = snodes[*d].LV;
    newheadLD = snodes[*h].LD;

    newheadind = get_node(*(snodes[*h].mnode), newheadprop, newheadLH, newheadLV);
    if( newheadind < 0 )
    {
      newheadind = sgraph.clone(*h,newheadprop);
      list<int>::iterator nextit=h; ++nextit;
      nodelist.insert(nextit,newheadind);
      snodes[newheadind].LH=newheadLH;
      snodes[newheadind].in_LH=true;
      snodes[newheadind].LV.reset();
      snodes[newheadind].LD = newheadLD;
      
      if(debug) sgraph.print_node_debug(stderr," C ",newheadind);
    }
    else
      snodes[newheadind].LD |= newheadLD; // TYLKO DLA LD
  }

  snodes[newheadind].deps.push_back(Arc(*d,r,*h));
  
  if(snodes[*d].saturated()) snodes[newheadind].LV |= snodes[*d].LV;
  snodes[newheadind].LD.set(*d);
  if(snodes[*d].saturated()) snodes[newheadind].LD |= snodes[*d].LD;
  
  if(debug)
    sgraph.print_arc(stderr,*d,newheadind,r,0), sgraph.print_node_debug(stderr," U ",newheadind);
}


void connect_right(list<int>::iterator h, list<int>::iterator d, Role r)
{
  NodeProp &oldheadprop = snodes[*h].prop;
  NodeProp newheadprop;
  bitset<MAXNODES> newheadLV;
  bitset<MAXNODES> newheadLH;
  bitset<MAXNODES> newheadLD;
  int newheadind;
  
  newheadprop = compute_prop_right(oldheadprop,r);
  if(oldheadprop==newheadprop)
    newheadind = *h;
  else
  {
    newheadLH = snodes[*h].LH;
    newheadLV = snodes[*h].LV;
    newheadLD = snodes[*h].LD;

    newheadind = get_node(*(snodes[*h].mnode), newheadprop, newheadLH, newheadLV);
    if( newheadind < 0 )
    {
      newheadind = sgraph.clone(*h,newheadprop);
      snodes[newheadind].LH=newheadLH;
      snodes[newheadind].in_LH=false;
      snodes[newheadind].LV=newheadLV;
      snodes[newheadind].LD=newheadLD;
      list<int>::iterator nextit=h; ++nextit;
      nodelist.insert(nextit,newheadind);
      
      if(debug) sgraph.print_node_debug(stderr," C ",newheadind);
    }
    else
      snodes[newheadind].LD |= newheadLD; // TYLKO DLA LD
  }
  
  snodes[*d].heads.push_back(Arc(newheadind,r,*h));

  snodes[*d].LH.set(newheadind);

  if(snodes[newheadind].saturated()) snodes[*d].LH |= snodes[newheadind].LH;

  if(debug)
    sgraph.print_arc(stderr,newheadind,*d,r,1), sgraph.print_node_debug(stderr," U ",*d);
  
}


void try_connect_dependents(list<int>::iterator j)
{
  for(list<int>::iterator i(j); i!=nodelist.begin(); --i)
    if(sgraph.visible(*i,*j) && sgraph.saturated(*i))
    {
      Roles& ji_roles = grammar.connect[snodes[*j].mnode->cat][snodes[*i].mnode->cat];
      for(RolesIter r=ji_roles.begin(); r!=ji_roles.end();++r)
        if(grammar.check_constr(snodes[*j].prop,snodes[*i].prop,0,*r))
          connect_left(j,i,*r);
    }
}


void try_connect_heads(list<int>::iterator j)
{
  for(list<int>::iterator i(j); i!=nodelist.begin(); --i)
    if(sgraph.visible(*i,*j))
    {
      Roles& ij_roles = grammar.connect[snodes[*i].mnode->cat][snodes[*j].mnode->cat];
      for(RolesIter r=ij_roles.begin(); r!=ij_roles.end();++r)
        if(grammar.check_constr(snodes[*i].prop,snodes[*j].prop,1,*r))
          connect_right(i,j,*r);
    }
}


void reverse_links()
{
  list<int>::iterator i = nodelist.begin();
  for(++i; i!=nodelist.end(); ++i)
    {
      for(vector<Arc>::iterator da=sgraph.nodes[*i].deps.begin()--; da!=sgraph.nodes[*i].deps.end(); ++da)
        sgraph.nodes[da->dst].heads.push_back(Arc(*i,da->role,da->anc));
      for(vector<Arc>::iterator ha=sgraph.nodes[*i].heads.begin(); ha!=sgraph.nodes[*i].heads.end(); ++ha)
        sgraph.nodes[ha->dst].deps.push_back(Arc(*i,ha->role,ha->anc));
    }
}


void dgp0()
{
  snodes=sgraph.nodes;

  nodelist.clear();
  nodelist.push_back(0); // BOS
  processed=nodelist.begin();

  for(int m=0; m<mgraph.n ; ++m)
  {
    int basenode = sgraph.add_base_snode(mgraph.nodes+m); // ma zwraca SNode*
    set_initial_constraints(basenode);
    nodelist.push_back(basenode);

    if(debug) {sgraph.print_node_debug(stderr,"B  ",basenode);} // STDOUT!!!

    list<int>::iterator cursor=processed;
    while(++cursor != nodelist.end())
    {
      try_connect_dependents(cursor);
      try_connect_heads(cursor);
      processed=cursor;
    }
  }
  reverse_links();
}
