#!/usr/bin/perl

#package:	UAM Text Tools
#component:	gph
#version:	1.0
#author:	Tomasz Obrebski

use strict;
use Getopt::Long;
use File::HomeDir;





my $systemconfigfile='/usr/local/etc/utt/gph.conf';
my $userconfigfile=home()."/.utt/gph.conf";

Getopt::Long::Configure('no_ignore_case_always');

my $help=0;
my $inputfile=0;
my $outputfile=0;
my @process=();
my $reset;
my $interactive=0;

#read configuration files###########################
my $file;
my @process_conf=();
foreach $file ($systemconfigfile, $userconfigfile){
  if(open(CONFIG, $file)){
        while (<CONFIG>) {
                chomp;
                s/#.*//;
                s/^\s+//;
                s/\s+$//;
                next unless length;
                my ($name, $value) = split(/\s*=\s*/, $_, 2);
                if(($name eq "inputfile")or($name eq "f")){
                        $inputfile=$value;
                }
                elsif(($name eq "outputfile")or($name eq "o")){
                        $outputfile=$value;
                }
                elsif(($name eq "process")or($name eq "p")){
                        push @process_conf, $value;
                }
                elsif(($name eq "reset")or($name eq "r")){
                        $reset=$value;
                }
                elsif(($name eq "interactive")or($name eq "i")){
                        $interactive=1;
                }
                elsif(($name eq "help")or($name eq "h")){
                        $help=1;
                }

        }
        close CONFIG;
  }
}
#########################################################



GetOptions("process|p=s" => \@process,
           "inputfile|f=s" => \$inputfile,
           "outputfile|o=s" => \$outputfile,
	   "help|h" => \$help,
	   "reset|r=s" => \$reset,
	   "interactive|i" => \$interactive);

@process = @process_conf if @process<1;

if($help)
{
    print <<'END'
Usage: gph [OPTIONS]

Options:
   --process=TYPE -p TYPE    Process segments of type TYPE.
   --reset=TYPE -r TYPE      Start new graph at tags of type TYPE.
   --inputfile=FILE -f FILE  Input file.
   --outputfile=FILE -o FILE Output file.
   --interactive -i          Toggle interactive mode (default=off).
END
;
    exit 0;
}


$|=1 if $interactive;


if(!$inputfile or $inputfile eq "-") {
	*INPUT = *STDIN;
}
else {
	open(INPUT, "$inputfile") or die("Can't open input file: $inputfile!");
}

if(!$outputfile or $outputfile eq "-") {
	*OUTPUT = *STDOUT;
}
else {
	open(OUTPUT, "$outputfile") or die("Can't open output file: $outputfile!");
}

my @prev;
my $n=0;

while(<INPUT>)
{
    chomp;
    my $do=0;

    my @line = split /\s+/;

    if($line[2] eq $reset)
    {
	$n=0;
	@prev = ();
    }

    for my $p (@process)
    {
	$do=1 if $line[2] eq $p;
    }

	my $gph = '';
    if($do)
    {
	my @preds = ();
	shift @prev while @prev+0 && $prev[0]->[1] + $prev[0]->[2] < $line[0];
	for my $p (@prev)
	{
	    push(@preds, $p->[0]) if $p->[1] + $p->[2] == $line[0];
	}
	push @prev, [$n, $line[0], $line[1]];
	
	$gph=' gph:'.$n.':'.join(',',@preds);

	$n++;
    }
    else
    {
	for my $p (@prev)
	{
	    if($p->[1]+$p->[2] == $line[0])
	    {
		$p->[2] += $line[1];
	    }
	}

	$gph='';

    }

    print OUTPUT $_.$gph."\n";    
}

