#include <stdlib.h>
#include <string.h>
#include "common_cor.h"

#define MAX_PATH_LENGTH 255

char dictionary[MAX_PATH_LENGTH];
char file_weights[MAX_PATH_LENGTH];
float threshold;
bool show_scores = false;
int result_count;

void process_cor_options(gengetopt_args_info* args)
{
  if(args->dictionary_given)
    {
      expand_path(args->dictionary_arg,dictionary);
    }
  else if (args->dictionary_home_given && args->language_given)
    {
      char buf[MAX_PATH_LENGTH];
      expand_path(args->dictionary_home_arg, buf);
      sprintf(dictionary,"%s/%s/cor.bin",buf,args->language_arg);
    }
  
  expand_path(args->weights_arg, file_weights);
  
  threshold = args->threshold_arg;

  show_scores = args->show_scores_flag;

  if(args->count_given) {
    result_count = args->count_arg;
  }
  else {
    result_count = 0;
  }
}
