#include <stdlib.h>
#include <ctype.h>
#include "../lib/iotools.h"
#include "common_cor.h"
#include "corr.hh"
#include <locale.h>


int main(int argc, char** argv) {

//   setlocale(LC_CTYPE,"");
//   setlocale(LC_COLLATE,"");

  gengetopt_args_info args;

  if(cmdline_parser(argc, argv, &args) != 0)
    exit(1);

  process_config_files(&args,argv[0]);
  process_common_options(&args,argv[0]);
  process_cor_options(&args);

  Corr cor;

  cor.load(dictionary);
  cor.t=args.distance_arg;

  //>>>>>>>>>>>>>>>
  cor.CL.cor_stdcor=1*PREC;
  cor.CL.cor_xchg=1*PREC;
  if (cor.load2(file_weights)==-1) return -1;  // moje
  cor.t=1*PREC; // ODLEGLOSC EDYCYJNA
  //<<<<<<<<<<<<<<

  char line[MAX_LINE+1];
  long line_count = 0;

  Segment seg;
  Words tab;
  char form1[MAX_LINE];
  char* form;
  int formcasing;
  char corfield[MAX_LINE]="";

  while (fgets(line, MAX_LINE, inputf))
    {
      ++line_count;
      char outline[128];

      if (!process_seg(line, args))
	fputs(line, outputf);
      else
	{
	  char form[MAX_FORM];
	  
	  tab.clear();
	  getfield(line,input_field_prefix,form);
	  if (form==NULL) continue;
	  
	  formcasing=3;
	  cor.correct(form, tab);
	  
	  if( tab.count() == 0 )
	    {
	      formcasing=casing(form);
	      if( formcasing == 1 || formcasing == 2)
		tolowers(form, form1), cor.correct(form1, tab);
	    }
	  
	  if ( tab.count() == 0)
	    fputs(line, inputf);
	  else 
	    {
	      	      tab.sort();

		int max_cnt = 0;
		if(result_count < 1) {
			max_cnt = tab.count();
		}
		else {
			max_cnt = (tab.count() < result_count) ? tab.count() : result_count;
		}
		
	      if(args.replace_flag)
		{
		  char corfield[128];
		  strcpy(corfield, input_field_prefix);
		  strcat(corfield, form);
		  seg.aux[seg.auxn]=corfield;
		  ++seg.auxn;
		  for(int i=0; i<tab.count(); ++i)
		    {
		      seg.form=tab[i].form();
		      restorecasing(seg.form,seg.form,formcasing);
		      seg.print(outline);
		      fputs(outline, outputf);
		    }
		  --seg.auxn;
		}
	      else
		{
		  if(one_line)
		    {
		      char* p=corfield;
		      for(int i=tab.count()-1; i >= tab.count()-max_cnt; --i)
			{
			  if(tab[i].w_suf() > threshold) continue;
			  restorecasing(tab[i].form(),tab[i].form(),formcasing);
			  p += sprintf(p," %s%s",output_field_prefix,tab[i].form());
			  if(show_scores) {
			    p += sprintf(p,",%1.2f",tab[i].w_suf());
			  }
			}
		      sprintf(p,"\n");

		      strcpy(outline,line);
		      outline[strlen(outline)-1]='\0';
		      strcat(outline,corfield);
		      fputs(outline, outputf);
		    }
		  else if(one_field)
		    {
		      char* p=corfield;
		      p += sprintf(p," %s",output_field_prefix);
		      for(int i=tab.count()-1; i >= tab.count()-max_cnt; --i)
			{
			  if(tab[i].w_suf() > threshold) continue;
			  restorecasing(tab[i].form(),tab[i].form(),formcasing);
			  p += sprintf(p,(i==0)?"%s":";%s",tab[i].form());
			  if(show_scores) {
			    p += sprintf(p,",%1.2f",tab[i].w_suf());
			  }
			}
		      
		      sprintf(p,"\n");

		      strcpy(outline,line);
		      outline[strlen(outline)-1]='\0';
		      strcat(outline,corfield);
		      fputs(outline, outputf);
		    }
		  else
		    {
		      for(int i=tab.count()-1; i >= tab.count()-max_cnt; --i)
			{
			  if(tab[i].w_suf() > threshold) continue;
			  restorecasing(tab[i].form(),tab[i].form(),formcasing);
			  char* p = corfield;
			  p += sprintf(p," %s%s",output_field_prefix,tab[i].form());
			  if(show_scores) {
				p += sprintf(p,",%1.2f",tab[i].w_suf());
			  }
			  p += sprintf(p, "\n");
			  strcpy(outline,line);
			  outline[strlen(outline)-1]='\0';
			  strcat(outline,corfield);
			  fputs(outline, outputf);
			}
		    }
		}
	    }
	}
      
      if(args.interactive_flag) fflush(outputf);
    }
  cmdline_parser_free(&args);
}
