#ifndef _MGRAPH_HH
#define _MGRAPH_HH

#include <vector>

#include "const.hh"
#include "thesymbols.hh"
#include "../common/common.h"


using namespace std;

class MNode
{
public:

  int            pos;
  char           form[256];
  Cat            cat;
  vector<int>    pred;
  vector<int>    snodes;

  void           clear() { snodes.clear(); };
};
 
class MGraph
{
public:

  void clear() { nodes.clear(); }
  int size() { return nodes.size(); }
  int add_node(char* seg);
  MNode& operator[](int i) { return nodes[i]; }

private:

  vector<MNode> nodes;

};

#endif
