
#include "mgraph.hh"
#include "thesymbols.hh"
#include "const.hh"

#include <cstdio>

int MGraph::add_node(char* seg)
{
  MNode newnode;
  newnode.clear();
  
  char field1[80], field3[80], field4[256], descr[256], gph[256];
  char* cat;
  
  getfield(seg,"1",field1);
  newnode.pos=atoi(field1);

  getfield(seg,"3",field3);

  getfield(seg,"4",field4);
  strcpy(newnode.form,field4);

  if(!getfield(seg,"lem",descr)) strcpy(descr,"?,?");

  cat=descr;
  while(*cat!=',' && *cat ) ++cat;
  if(*cat) ++cat;
  
  if(Cat::index(cat)>0)
    newnode.cat=cat;
  else
    newnode.cat="NULL";
  
  newnode.pred.clear();
  
  char* tok;
  int previd;
  
  if(!getfield(seg,"gph",gph))
  {
    fprintf(stderr,"No gph field. Aborting (sorry).\n");
    exit(1);
  }

  char* ids=strtok(gph,":");
  if(size() != atoi(ids)) {fprintf(stderr,"Invalid node id in line ?. Program aborted.\n"); exit(1); }
  
  char *preds;
  while(preds=strtok(NULL,","))
  {
    previd=atoi(preds);
    newnode.pred.push_back(previd);
  }

  nodes.push_back(newnode);
  return nodes.size()-1;
}

