#include <iostream>
using namespace std;

#include "dgp1.hh"
#include "global.hh"

extern Grammar grammar;
extern MGraph mgraph;
extern SGraph sgraph;

extern bool debug;

list<int> nodelist;
list<int>::iterator processed;


void print_sets(int n);


//====================================================================================================

void set_initial_constraints(int node)
{
  sgraph[node].prop.forbidden.reset();
  sgraph[node].prop.required=grammar.is_obl(sgraph.cat(node));
  sgraph[node].prop.attached.reset();
  sgraph[node].prop.flags=grammar.initial_flags(sgraph.cat(node));
}

//----------------------------------------------------------------------------------------------------

bool changing_constraints(int head, Role role)
{
  return grammar.is_sgl(role) || sgraph[head].prop.required[role];
}

//====================================================================================================

NodeProp compute_head_prop(NodeProp headprop, const Link& link, list<Boubble*> bs, FlagSet& depflags)
{
  NodeProp ret=headprop;

  if(grammar.is_sgl(link.role))
    {
      ret.forbidden.set(link.role);
      ret.attached.set(link.role);
    }
  ret.required.reset(link.role);

  ret.required |= (grammar.constr_include(link.role) & ~ret.attached);
  ret.forbidden |= grammar.constr_exclude(link.role);

  ret.boubbles.merge(bs); //DOBRZE
  ret.flags |= ( depflags & grammar.pass_flags(link.role) );

  if(link.props[Prop("INIT")]) ret.init_attached=true;
  if(link.props[Prop("FIN")]) ret.fin_attached=true;

  return ret;
}

//----------------------------------------------------------------------------------------------------

NodeProp compute_dep_prop(NodeProp depprop, const Link& link, list<Boubble*> bs)
{
  NodeProp ret=depprop;
  ret.boubbles.merge(bs); //DOBRZE
  return ret;
}

//====================================================================================================

int find_existing_node(int mnode, NodeProp p, Edge e)
{
  for(vector<int>::iterator i = mgraph[mnode].snodes.begin(); i!=mgraph[mnode].snodes.end(); ++i)
    if(sgraph[*i].prop==p && sgraph[*i].edge==e)
      { 
	if(debug) fprintf(stderr,"\t\treusing %d\n",*i);
	return *i;
      }
  return -1;
}

//====================================================================================================

list<Boubble*> receive_boubbles(int node, Role role, Dir dir)
{
  list<Boubble*> ret;
  for(list<Boubble*>::iterator b = sgraph[node].prop.boubbles.begin(); b!=sgraph[node].prop.boubbles.end(); b++)
    {
      Boubble* new_boubble = (*b)->step(role,dir);
      if(new_boubble)
	ret.push_back(new_boubble);
    }

  return ret;
}

//----------------------------------------------------------------------------------------------------

list<Boubble*> collect_head_boubbles(int head, int dep, Role role)
{
  list<Boubble*> new_boubbles = grammar.trigger_boubbles(sgraph.cat(dep),role,UP);
  
  for(list<Boubble*>::iterator b = new_boubbles.begin(); b != new_boubbles.end(); b++)
    (*b)->src(dep);

  list<Boubble*> received_boubbles = receive_boubbles(dep,role,UP);

  new_boubbles.insert(new_boubbles.begin(),received_boubbles.begin(),received_boubbles.end());

  return new_boubbles;
}

//----------------------------------------------------------------------------------------------------

list<Boubble*> collect_dep_boubbles(int head, int dep, Role role)
{
  list<Boubble*> new_boubbles = grammar.trigger_boubbles(sgraph.cat(head), role, DOWN);
  
  for(list<Boubble*>::iterator b = new_boubbles.begin(); b != new_boubbles.end(); b++)
    (*b)->src(head);

  list<Boubble*> received_boubbles = receive_boubbles(head,role,DOWN);

  new_boubbles.insert(new_boubbles.begin(),received_boubbles.begin(),received_boubbles.end());

  return new_boubbles;
}

//====================================================================================================

void copy_links(int i, int j)
{
  sgraph[j].heads = sgraph[i].heads;
  sgraph[j].deps = sgraph[i].deps;
}


void create_reverse_links(int n)
{
  for(vector<Arc>::iterator a=sgraph[n].heads.begin(); a != sgraph[n].heads.end(); a++)
    sgraph[a->dst].deps.push_back(Arc(n,a->role,a->headanc,a->depanc));

  for(vector<Arc>::iterator a=sgraph[n].deps.begin(); a != sgraph[n].deps.end(); a++)
    sgraph[a->dst].heads.push_back(Arc(n,a->role,a->headanc,a->depanc));
}

//====================================================================================================

int create_new_node(int anc, NodeProp& prop, Edge edge)
{
  int newheadind = sgraph.clone(anc,prop,edge);
  nodelist.push_back(newheadind);
  copy_links(anc,newheadind);
  create_reverse_links(newheadind);
  if(debug) sgraph.print_node_debug(stderr,"clone",newheadind,anc);
  // if(debug) print_sets(newheadind);
  return newheadind;
}

//====================================================================================================

void connect_left(int h, int d, const Link& l, list<Boubble*>& new_head_boubbles, list<Boubble*>& new_dep_boubbles)
{

  NodeProp &old_head_prop = sgraph[h].prop;
  NodeProp &old_dep_prop = sgraph[d].prop;
  NodeProp new_head_prop  = compute_head_prop(old_head_prop,l,new_head_boubbles,old_dep_prop.flags);
  NodeProp new_dep_prop = compute_dep_prop(old_dep_prop,l,new_dep_boubbles);
  
  Edge new_dep_edge(sgraph[d].edge);
  int newd = find_existing_node(sgraph[d].mnode, new_dep_prop, new_dep_edge);
  if( newd < 0  )
    newd = create_new_node(d,new_dep_prop,new_dep_edge);
  
  Edge new_head_edge(sgraph[newd].edge,newd);
  int newh = find_existing_node(sgraph[h].mnode, new_head_prop, new_head_edge);
  if( newh < 0 )
    newh = create_new_node(h,new_head_prop,new_head_edge);
    
  sgraph[newh].deps.push_back(Arc(newd,l.role,h,d));
  sgraph[newd].heads.push_back(Arc(newh,l.role,h,d));

  if(debug)
    {
      sgraph.print_arc(stderr,"link",newh,d,l.role,0);
      sgraph.print_node_debug(stderr,"",newh,h);
      sgraph.print_node_debug(stderr,"",newd,d);
    }
}

//----------------------------------------------------------------------------------------------------

void connect_right(int h, int d, const Link& l, list<Boubble*>& new_head_boubbles, list<Boubble*>& new_dep_boubbles)
{
  NodeProp &old_head_prop = sgraph[h].prop;
  NodeProp &old_dep_prop = sgraph[d].prop;
  NodeProp new_head_prop = compute_head_prop(old_head_prop,l,new_head_boubbles,old_dep_prop.flags);
  NodeProp new_dep_prop = compute_dep_prop(old_dep_prop,l,new_dep_boubbles);

  Edge new_head_edge(sgraph[h].edge);
  int newh = find_existing_node(sgraph[h].mnode, new_head_prop, new_head_edge);
  if( newh < 0 )
      {
	newh = create_new_node(h,new_head_prop,new_head_edge);
	sgraph[newh].visible_as_neighbour = false;
      }

  Edge new_dep_edge;
  int newd = find_existing_node(sgraph[d].mnode, new_dep_prop, new_dep_edge);
  if( newd < 0)
    newd = create_new_node(d,new_dep_prop,new_dep_edge);


  sgraph[newd].heads.push_back(Arc(newh,l.role,h,d));
  sgraph[newh].deps.push_back(Arc(newd,l.role,h,d));

  if(debug)
    {
      sgraph.print_arc(stderr,"link",newh,newd,l.role,1);
      sgraph.print_node_debug(stderr,"",newh,h);
      sgraph.print_node_debug(stderr,"",newd,d);
    }
  
}

//====================================================================================================

bool check_meeting_boubles(list<Boubble*>& boubbles)
{
  bool hremove=false;             // czy usun ostatnio sprawdzany bbel
  bool dremove=false;             // czy usun ostatnio sprawdzany bbel

  // cerr << "CHECKING MEETING BUBBLES" << endl;

  for(list<Boubble*>::iterator hb = boubbles.begin(); hb != boubbles.end(); hb = hremove ? boubbles.erase(hb) : ++hb )
    {
      hremove=false;
      for(list<Boubble*>::iterator db = hb; db != boubbles.end(); db = dremove ? boubbles.erase(db) : ++db )
	{
	  // cerr << " db:" << **db;
	  dremove=false;
	  if( (*hb)->rel()==(*db)->rel() && (*hb)->reverse()!=(*db)->reverse() )
	    {
	      // cerr << "Z"; 
	      int srcnode,dstnode;
	      if( (*hb)->reverse()==false )
		srcnode = (*hb)->src(), dstnode = (*db)->src();
	      else
		srcnode = (*db)->src(), dstnode = (*hb)->src();
	      if( grammar.check_longrel(sgraph.cat(srcnode), sgraph.cat(dstnode), (*hb)->rel()) )
		{
		  // cerr << " REMOVE ";
		  hremove=dremove=true;
		  if(debug) fprintf(stderr,"BOUBBLES MET!!!\n");
		}
	      else
		{
		  // cerr << " FAIL ";
		  if(debug) fprintf(stderr,"BOUBBLES' MEETING FAILED!!!\n");
		  return false;
		}
	    }
	}
    }
  return true;
}

//====================================================================================================

// sprawdza czy te, spord bbli, ktre dotary do celu node
// daj wynik prawdziwy, dodatkowo - usuwa je z listy boubbles

bool check_boubbles_at_target(list<Boubble*>& boubbles, int node)
{
  bool remove=false;             // czy usun ostatnio sprawdzany bbel

  for(list<Boubble*>::iterator b = boubbles.begin(); b != boubbles.end(); b = remove ? boubbles.erase(b) : ++b )
    if( (*b)->is_at_target() )
      if( grammar.check_longrel(sgraph.cat((*b)->src()), sgraph.cat(node), (*b)->rel()) )
	{
	  // cerr << endl << "REMOVE ChBatT " << **b << endl;
	  remove=true;
	}
      else
	return false;
    else
      remove=false;
      
  return true;
}

//====================================================================================================

void try_connect_dependents(int j)
{
  LViterator lvi(sgraph,j);
  int i;
  while((i=lvi.next()) >= 0)
      if(sgraph.saturated(i))
	{
	  if(debug) {fprintf(stderr,"\t%d <-- %d",i,j); }
	  
	  list<const Link*> ji_links = grammar.connectable2( sgraph.cat(j), sgraph.cat(i), sgraph[j].prop.flags, sgraph[i].prop.flags); // ref do Roles!!!
	  list<const Link*>::iterator ri = ji_links.begin();
	  if(ri == ji_links.end()) { if(debug) fprintf(stderr,"     no roles\n"); }
	  else
	    {
	      for(; ri != ji_links.end(); ++ri )
		{
		  if(debug) fprintf(stderr,"     %s",(*ri)->role.str());
		  if(!grammar.check_constr2(sgraph[j].prop,sgraph[i].prop,0,**ri ))
		    { if(debug) fprintf(stderr," ...constraints failed\n"); }
		  else
		    {
		      list<Boubble*> new_head_boubbles = collect_head_boubbles(j,i,(*ri)->role);
		      list<Boubble*> new_dep_boubbles = collect_dep_boubbles(j,i,(*ri)->role);
		      if( check_meeting_boubles(new_head_boubbles) &&
			  check_meeting_boubles(new_dep_boubbles) &&
			  check_boubbles_at_target(new_head_boubbles,j) &&
			  check_boubbles_at_target(new_dep_boubbles,i) )
			{
			  if(debug) fprintf(stderr," ...SUCCESS!\n");
			  connect_left( j, i, **ri, new_head_boubbles, new_dep_boubbles);
			  // lvi.update_edge(sgraph,i);
			}
		      else
			{ if(debug) fprintf(stderr," ...boubbles failed\n"); }
		    }
		}
	    }
	}
      else
	if(debug) {fprintf(stderr,"\t%d <-- %d\t%d unsaturated\n",i,j,i); }  
}
//----------------------------------------------------------------------------------------------------

void try_connect_heads(int j)
{
  LViterator lvi(sgraph,j);
  int i;
  while((i=lvi.next()) >= 0)
    if(sgraph.saturated(j))
      {
	if(debug) fprintf(stderr, "\t%d --> %d",i,j);
	
	list<const Link*> ij_links = grammar.connectable2( sgraph.cat(i), sgraph.cat(j), sgraph[i].prop.flags, sgraph[j].prop.flags );
	list<const Link*>::iterator ri = ij_links.begin();
	if(ri == ij_links.end()) { if(debug) fprintf(stderr,"     no roles\n"); }
	else
	  {
	    for(; ri != ij_links.end(); ++ri )
	      {
		if(debug) fprintf(stderr,"     %s",(*ri)->role.str());
		if( !grammar.check_constr2( sgraph[i].prop, sgraph[j].prop, 1, **ri ) )
		  { if(debug) fprintf(stderr," ...constraints failed\n"); }
		else
		  {
		    list<Boubble*> new_head_boubbles = collect_head_boubbles(i,j,(*ri)->role);
		    list<Boubble*> new_dep_boubbles = collect_dep_boubbles(i,j,(*ri)->role);
		    
		    if( check_meeting_boubles(new_head_boubbles) &&
			check_meeting_boubles(new_dep_boubbles) &&
			check_boubbles_at_target(new_head_boubbles,i) &&
			check_boubbles_at_target(new_dep_boubbles,j) )
		      {
			if(debug) fprintf(stderr," ...SUCCESS!\n");
			connect_right( i, j, **ri, new_head_boubbles, new_dep_boubbles );
		      }
		    else
		      { if(debug) fprintf(stderr," ...bubbles failed\n",i); }
		  }
	      }
	  }
      }
    else
      if(debug) {fprintf(stderr,"\t* <-- %d    unsaturated\n",j); }
}

//====================================================================================================

void update_sets()
{
  for(int n=0; n<sgraph.size(); ++n)
    {
      LViterator lvi(sgraph,n,false);
      LHiterator lhi(sgraph,n);
      LDiterator ldi(sgraph,n);
      int i;

      // printf("UPDATING LV[%d]:",n);
      while((i=lvi.next())>=0)
	{
	  // printf(" %d",i);
	  sgraph[n].LV.set(i);
	}
      // printf("\n");

      while((i=lhi.next())>=0) sgraph[n].LH.set(i);
      while((i=ldi.next())>=0) sgraph[n].LD.set(i);
    }
}

//====================================================================================================

void print_sets(int n)
{
  LViterator lvi(sgraph,n);
  LHiterator lhi(sgraph,n);
  LDiterator ldi(sgraph,n);
  
  int i;  
  printf("LV[%d]: ",n);
  while((i=lvi.next())>=0)
	{
	  printf("%d ",i);
	  sgraph[n].LV.set(i);
	}

  printf("LH[%d]: ",n);
  while((i=lhi.next())>=0)
    {
      printf("%d ",i);
      sgraph[n].LH.set(i);
    }
  printf("LD[%d]: ",n);
  while((i=ldi.next())>=0)
    {
      printf("%d ",i);
      sgraph[n].LD.set(i);
    }
  printf("\n");
}

//====================================================================================================

void reverse_links()
{
  list<int>::iterator i = nodelist.begin();
  for(++i; i!=nodelist.end(); ++i)
    {
      for(vector<Arc>::iterator da=sgraph[*i].deps.begin()--; da!=sgraph[*i].deps.end(); ++da)
        sgraph[da->dst].heads.push_back(Arc(*i,da->role,da->headanc,da->depanc));
      for(vector<Arc>::iterator ha=sgraph[*i].heads.begin(); ha!=sgraph[*i].heads.end(); ++ha)
        sgraph[ha->dst].deps.push_back(Arc(*i,ha->role,ha->headanc,ha->depanc));
    }
}

//====================================================================================================

void dgp1()
{

  nodelist.clear();
  nodelist.push_back(0); // BOS
  processed=nodelist.begin();

  for(int m=0; m<mgraph.size() ; ++m)
  {
    int basenode = sgraph.add_base_snode(m); // ma zwraca SNode*

    set_initial_constraints(basenode);
    nodelist.push_back(basenode);

    if(debug) sgraph.print_node_debug(stderr,"node",basenode,-1); // STDOUT!!!
    // if(debug) print_sets(basenode);

    list<int>::iterator cursor=processed;
    while(++cursor != nodelist.end())
    {
      if(debug) sgraph.print_node_debug(stderr,"CUR>",*cursor,-1);
      try_connect_dependents(*cursor);
      try_connect_heads(*cursor);
      processed=cursor;
    }

  }
   // reverse_links();
  update_sets();
}
