%{

  void print_EOS(void);
  void set_position(void);

  int pos=0;
  int len=0;

%}

ul      [A-ZʣӦ]
ll      [a-z󶿼]
l       ul|ll
n       [0-9]+
s       [ \t]+


ab1     (mgr|in|prof|hab|doc|dyr|kier|zast)
ab2     (ul|pl|al)
ab3	(str|ryc|rys)
ab4	(np|tzw)

abrv    ({ab1}|{ab2}|{ab3})

SEG     .*\n
N       {n}{s}{n}{s}N{s}.*\n
S       {n}{s}{n}{s}S{s}.*\n
P       {n}{s}{n}{s}P{s}.*\n
W       {n}{s}{n}{s}W{s}.*\n
UL      {n}{s}{n}{s}W{s}{ul}.*\n
Cap     {n}{s}{n}{s}W{s}{ul}{ll}*.*\n
POINT   {n}{s}{n}{s}P{s}\.({s}.*)?\n
QMARK   {n}{s}{n}{s}P{s}\?({s}.*)?\n
EXCL    {n}{s}{n}{s}P{s}\!({s}.*)?\n
DASH    {n}{s}{n}{s}P{s}\-({s}.*)?\n
POINTS  {POINT}+

ABRV    {n}{s}{n}{s}W{s}{abrv}({s}.*)?\n

EOS     {POINT}|{POINTS}|{QMARK}|{EXCL}


%%


{N}({POINT}{N})+          { ECHO; set_position(); }
({UL}{POINT}{S}?)+{Cap}   { ECHO; set_position(); }
{ABRV}{POINT}             { ECHO; set_position(); }


{P}/{S}{DASH}             { ECHO; set_position(); print_EOS(); }
{EOS}/{S}({Cap}|{P}|{N})  { ECHO; set_position(); print_EOS(); }

.*                        { ECHO; set_position(); }

<<EOF>>                   { printf("%04d 00 EOS *\n",pos+len); exit(0); }

%%

int main()
{
  printf("0000 00 BOS *\n");
  yylex();
  return 0;
}

int yywrap()
{
  return 1;
}

void set_position()
{
  char *lastseg;
  char *tmp;

  yytext[yyleng-1] = '\0';

  tmp = strrchr(yytext, '\n');
  if( tmp )
  {
    lastseg = tmp + 1;
  }
  else
  {
    lastseg = yytext;
  }

  sscanf(lastseg, "%d %d", &pos, &len);
  yytext[yyleng-1] = '\n';

}

void print_EOS()
{
  printf("%04d 00 EOS *\n%04d 00 BOS *\n", pos+len, pos+len);
}
