#! /usr/bin/perl

use locale;
use strict;

my $file = shift;

if ($file eq "") {
    print "Podaj nazw pliku.\n";
    exit(0);
}


`makeLabels.pl > labels.sym`;

`lexmakelab labels`;

print "Pobieram informacje ze sownika..........................";

`cut -d \\; -f 1 <$file > temp1`;

`sort -u < temp1 > temp2`;

print "OK\n";

print "Kompiluj automat........................................";

`lexcomplex -l labels.lab -S labels.scl <temp2 > temp1`;

print "OK\n";

print "Usuwam epsilon-przejscia.................................";

`fsmrmepsilon temp1> temp2`;

print "OK\n";

print "Determinizuj automat....................................";

`fsmdeterminize temp2 > temp1`;

print "OK\n";

print "Minimalizuj automat.....................................";

`fsmminimize temp1> temp2`;

print "OK\n";

print "Konwertuj automat do formatu fsa........................";

`fsmprint -i labels.lab temp2> temp1`;

`../fsm2aut temp1> temp2`;

`../aut2fsa < temp2> cor.dic`;

print "OK\n";

print "Czyszcz pliki pomocnicze................................";

`rm temp2`;
`rm temp1`;
`rm labels.*`;

print "OK\n";

