#include <stdlib.h>
#include <string.h>
#include "common_tok.h"

char dictionary[255];

void process_tok_options(gengetopt_args_info args)
{
  if(args.dictionary_given)
    strcpy(dictionary, args.dictionary_arg);
  else {
    char path[256];
    sprintf(path, "/etc/utt/%s", DICT_FILE);
    if (file_accessible(path) == 0)
      strcpy(dictionary, path);
    else {
      sprintf(path, "%s/.utt/%s", getenv("HOME"), DICT_FILE);
      if (file_accessible(path) == 0)
	strcpy(dictionary, path);
      else {
	fprintf(stderr, "Cannot find dictionary!\n");
	exit(1);
      }
    }
  }

}
