#include <time.h>
#include <stdlib.h>
#include "../lib/iotools.h"
#define _CMDLINE_FILE "../gue/cmdline.h"
#define CONFIGFILE1 "/home/ynka/utt/utt-0.9/conf/gue.conf"
#define CONFIGFILE2 "/home/ynka/utt/utt-0.9/conf/gue.conf"
#include "../common/common.h"
#include "common_guess.h"
#include "guess.h"
#include "cmdline.h"

#define W_SUFF 0.6
#define W_PREF 0.4

int main(int argc, char** argv) {

  //  int non_standard_config=0;

  gengetopt_args_info args;

  if(cmdline_parser(argc, argv, &args) != 0)
    exit(1);

  process_config_files(&args,argv[0]);
  process_common_options(&args,argv[0]);
  process_guess_options(&args);


  // PONIŻEJ POPRZEDNI KOD (JUSTYNY)
// //preliminary command-line parsing - for configuration file info only
//   gengetopt_args_info pre_args;

//   if (cmdline_parser(argc, argv, &pre_args) != 0)
//     	exit(1);
//   if(pre_args.config_given){
// 	printf("podano config: %s\n",pre_args.config_arg);
// 	non_standard_config=1;
//   }
  

// //configuration file 1 parsing
// 	struct cmdline_parser_params *params;	
// 	params = cmdline_parser_params_init();
// 	params->initialize = 1;
// 	if(cmdline_parser_config_file(CONFIGFILE1,&args, params)!=0){
// 		printf("System-wide configuration file parsing error!\n");		
// 		exit(1);
// 	}  

// //configuration file 2 parsing-overriding
// 	params->initialize=0;
// 	params->override=1;
// 	char* config2=(non_standard_config)?pre_args.config_arg:CONFIGFILE2;
// 	if(cmdline_parser_config_file(config2,&args, params)!=0){
// 		printf("User configuration file parsing error!\n");		
// 		return 1;
// 	}

// 	params->initialize=0;
// 	params->override=1;
// 	//params->check_required=1;
	
// 	free(params);

// //command-line options parsing-overriding
//   if (cmdline_parser(argc, argv, &args) != 0)
//     exit(1);


  char line[MAX_LINE];
  char outline[MAX_LINE];
  char parms[MAX_LINE], desc[MAX_LINE], lemma[MAX_LINE];
  long line_count = 0;
  
  Guess guess(dictionary);
  int words_count=0;
  time_t start_time = time(NULL);
  
  //  Segment seg;
  Words tab;
  while (fgets(line, MAX_LINE, inputf))
    {
      line_count++;
      int start, len;
      
      line[strlen(line)-1] = '\0';
      
      if (!process_seg(line, args))
	fputs(line,outputf);
      else
	{
	  char form[MAX_FORM];
	  words_count++;
	  tab.clear();
	  getfield(line,input_field_prefix,form);
	  if (form==NULL) continue;//BZDURA
	  
	  guess.ana(form, tab);
	  
	  if ((tab.count()==0) && (!args.no_fail_flag)) // no guesses - analysis was unsuccessful
	    fputs(line, failedf);
	  else
	    {

// 	      if (copy_processed)
// 		fputs(line, stdout);
// 	      continue;
// 	    }
	  // we've got some guesses. Do we want to print it?
// 	      if (args.only_fail_flag)
// 	    continue;

	      float last_weight=0;
	      int i=0;
	      int count=0;
	      unsigned first=1;
	      char* parms_end = parms;
	      char last_lemma[MAX_LINE];
	      
	      while ((i=tab.next()) != -1 && count++<guess_count) {
		/* if we have "one-line" flag then everything goes in one segment as many fields,
		 * if we have "one-field" flag everything goes in one segment as ONE field:
		 * - diferent lemmas are separated with ';', sequent descriptions to one lemma
		 *   are separated with ','
		 */
		if ((!first) && (tab[i].w_suf() < cut_off) || (tab[i].w_suf() < delta * last_weight)) {
		  break;
		}
		if (first) {
		  parms_end += sprintf(parms_end, "%s", field_prefix);
		} else if (!args.one_field_flag)
		  parms_end += sprintf(parms_end, "%s", field_prefix);
		
		if (!args.one_field_flag || strcmp(last_lemma, tab[i].lemma()) != 0) {
		  if (args.one_field_flag && !first)
		    parms_end += sprintf(parms_end, ";");
		  parms_end += sprintf(parms_end, "%s", tab[i].lemma());
		  strcpy(last_lemma, tab[i].lemma());
		}
		
		first=0;
		
		last_weight = tab[i].w_suf();
		if (!weights)
		  parms_end += sprintf(parms_end, ",%s:%d",  tab[i].descr(), (int)tab[i].w_suf());
		else
		  parms_end += sprintf(parms_end, ",%s", tab[i].descr());
		
		if (!args.one_field_flag) {
		  seg.addfield(parms);
		  parms_end = parms;
		}
		
		if (!(args.one_field_flag || args.one_line_flag)) {
		  seg.print(outline);
		  fputs(outline, outputf);
		  --seg.auxn;
		}
		//if (copy_processed)
		//  fputs(outline, stdout);
	      } //while
	      
	      if (args.one_field_flag)
		seg.addfield(parms);
	      
	      if (args.one_field_flag || args.one_line_flag){
		seg.print(outline);
		fputs(outline, outputf);
	      }
	    } else { // if (process_segment)
	    // jak to nie jest wyraz - to przepisz token na wyjscie.
	    //      printtok(line, start, len, cat, form);
	    seg.print(outline);
	    fputs(outline, outputf);
	    if (copy_processed)
	      fputs(outline, stdout);
	  }
	}
      time_t end_time = time(NULL);
      if (per_info) {
	printf("Liczba s³ów: %d\n", words_count);
	printf("Czas analizy: %d sekund\n", end_time-start_time);
      }
      cmdline_parser_free(&args);
    }
  
