//---------------------------------------------------------------------------
#include "word.h"
#include "auttools.h"
#include <istream.h>
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------

void Word::autodescr(const char* fo, const char* de)
{
  strcpy(f,fo);
  //  len=strlen(f);

  char lemd[MAXDESCRLEN];
  int i=strcspn(de,",");
  strncpy(lemd,de,i);
  lemd[i]='\0';
  if(isdigit(lemd[0]))
    fullform(f,lemd,l);  // jeli lemat zakodowany
  else
    strcpy(l,lemd);     // jeli lemat w penej postaci
  strcpy(d,de+i+1);
}

//---------------------------------------------------------------------------
bool Word::cmp_w(Word a, Word b) {
  return (a.w_suf() > b.w_suf());
}
//---------------------------------------------------------------------------

istream& operator>>(istream& is, Word& w)
{
  char temp[Word::MAXLEN+1];
  char c;

  int i=0;
  while(i<Word::MAXLEN && is.get(c) && isalpha(c)) temp[i++]=c;
  if(i==Word::MAXLEN) {
    fprintf(stderr, "To long word");
  }
  if(i==0) is.clear(ios::badbit);
  temp[i]='\0';
  if(is)
    is.putback(c);
  strcpy(w.f,temp);
  //  w.len=i;
  return is;
}

//---------------------------------------------------------------------------

ostream& operator<<(ostream& os, Word& w)
{
  if(*(w.f))
    os << "<W " << w.form()
       << ";" << w.lemma()
       << ',' << w.descr() << '>';
  return os;
}

//---------------------------------------------------------------------------
Words::~Words() {
  //   for (int i=0; i<tab.size(); ++i)
//     delete(tab[i]);
}
//---------------------------------------------------------------------------

int Words::find(const char* word) {
  for (int i=0; i<cnt; ++i) {
    if (strcmp(word, tab[i].form()) == 0) {
	return i;
    }
  }
  return -1;
}


//---------------------------------------------------------------------------

int Words::find(const char* word, const char* descr) {
  for (int i=0; i<cnt; ++i) {
    if ((strcmp(word, tab[i].form()) == 0) && (strcmp(descr, tab[i].descr()) == 0)) {
	return i;
    }
  }
  return -1;
}

//---------------------------------------------------------------------------
/* zwraca index nastepnego wyniku, podczas pierwszego wywolania
 * zwraca index wyniku o najwiekszej wadze, przy drugim wywolaniu
 * wynik z druga najwyzsza waga, itd.
 * Jezeli nie ma juz wynikow - zwraca -1.
 */
int Words::next() {
  float max = -1;
  int result = -1;
  for (int i=0; i<cnt; ++i) {
    float w = tab[i].w_suf();
    if (w>max && !tab[i].returned) {
      max = w;
      result = i;
    }
  }
  if (result != -1)
    tab[result].returned = 1;
  return result;
}

//---------------------------------------------------------------------------
void Words::sort() {
  std::sort(tab.begin(), tab.end(), Word::cmp_w);
}

//---------------------------------------------------------------------------

int Words::add(const char* fo)
{
  int i = find(fo);
  if(i!=-1) {
    return i;
  }
  
  if (cnt>=tab.capacity()-1)
    tab.resize(tab.size()*2);
  

  Word o;
  o.form(fo);
  o.w_suf(0.0);
  tab.push_back(o);
//  tab[cnt].form(fo);
//  tab[cnt].w_suf(0.0);


  //  if(cnt<MAX-1) {
  /* tab.push_back(new Word());
    tab[cnt]->form(fo);
    tab[cnt]->w_suf(0.0);
    tab[cnt]->w_pref(0.0);*/
    return cnt++;
    //  }
    //return -1;
}

//---------------------------------------------------------------------------

 //TYMCZASOWO TAK(DLA CORA)
int Words::add(const char* fo, float weight)
{
  int i = find(fo);
  if(i!=-1) {
    return i;
  }
  
  if (cnt>=tab.capacity()-1)
    tab.resize(tab.size()*2);
  
  Word o;
  o.form(fo);
  o.w_suf(weight);
  tab.push_back(o);
//  tab[cnt].form(fo);
//  tab[cnt].w_suf(weight);
  
    return cnt++;
    //  }
    //return -1;
}

//---------------------------------------------------------------------------

int Words::add(const char* fo, const char* des)
{
  char d[Word::MAXDESCRLEN];
  int l=strcspn(des,",");
  int ok=1;
  if( *(des+l) == ',' )
    {
      strcpy(d,des+l+1);
      //  printf("\t%s->%s,\n", des, d);
      int i=find(fo, d);
      if(i!=-1)
        return i;
    }
  else
    ok=0;

  if (cnt>=tab.capacity()-1)
    tab.resize(tab.size()*2);

  tab[cnt].form(fo);
  if(ok)
    tab[cnt].autodescr(fo, des);
  else
    tab[cnt].autodescr(fo, "?,?");
  
  tab[cnt].w_suf(0.0);
  tab[cnt].returned = 0;
  /*
  //  if(cnt<MAX-1) {
    tab.push_back(new Word());
    tab[cnt]->form(fo);
    tab[cnt]->autodescr(fo,des);
    tab[cnt]->w_suf(0.0);
    tab[cnt]->w_pref(0.0);
    //    printf("ok!\n");*/
    return cnt++;
    //  }
    //  printf("hm\n");
  return -1;
}

//---------------------------------------------------------------------------
void Words::prn(ostream& os)
{
  for(int i=0; i<count(); ++i)
    os << "<W " << tab[i].lemma() << ',' << tab[i].descr() << ">";
}

//---------------------------------------------------------------------------

ostream& operator<<(ostream& os, Words& tab)
{
  /*  for(int i=0; i<tab.count(); ++i)
    os << i << ". " << tab[i] << '\n';
    return os;*/
}

//---------------------------------------------------------------------------

