#include <stdlib.h>
#include <string.h>
#include "common_cor.h"

char dictionary[256];

void process_cor_options(gengetopt_args_info* args)
{
  if(args->dictionary_given)
    {
      expand_path(args->dictionary_arg,dictionary);
      if(file_accessible(dictionary)!=0)
	{
	  fprintf(stderr,"Cannot open the dictionary file: %s\nAborting.\n",dictionary);
	  exit(1);
	}
    }
  else if (args->dictionary_home_given && args->language_given)
    {
      char buf[255];
      expand_path(args->dictionary_home_arg, buf);
      sprintf(dictionary,"%s/%s/cor.bin",buf,args->language_arg);
      if(file_accessible(dictionary)!=0)
	{
	  fprintf(stderr,"Cannot open the dictionary file: %s\nAborting.\n",dictionary);
	  exit(1);
	}
    }
}
