/*
  File autogenerated by gengetopt version 2.22.4
  generated with the following command:
  gengetopt -i cmdline.ggo 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif

#include <getopt.h>

#include "cmdline.h"

const char *gengetopt_args_info_purpose = "";

const char *gengetopt_args_info_usage = "Usage: guess [OPTIONS]...";

const char *gengetopt_args_info_description = "";

const char *gengetopt_args_info_full_help[] = {
  "  -h, --help                 Print help and exit",
  "      --full-help            Print help, including hidden options, and exit",
  "  -V, --version              Print version and exit",
  "  -f, --input=STRING         Input file",
  "  -o, --output=STRING        Output file for succesfully processed segments",
  "  -e, --fail=STRING          Output file for unsuccesfully processed segments ",
  "      --only-fail            Print only segments the program failed to process  \n                               (default=off)",
  "      --no-fail              Print only segments the program processed  \n                               (default=off)",
  "  -c, --copy                 Copy succesfully processed segments to standard \n                               output  (default=off)",
  "  -p, --process=STRING       Process segments with this tag",
  "  -s, --select=STRING        Select only segments with this field",
  "  -S, --ignore=STRING        Select only segments without this field",
  "  -O, --output-field=STRING  Output field name",
  "  -I, --input-field=STRING   Input field name",
  "  -i, --interactive          Toggle interactive mode  (default=off)",
  "      --config=FILENAME      Configuration file",
  "  -1, --one-field            Print all results in one segments (creates \n                               ambiguous annotation)  (default=off)",
  "      --one-line             Print annotation alternatives as additional fields \n                                (default=off)",
  "      --language=STRING      Language.",
  "  -l, --color                Show guessed descriptions in colour.  \n                               (default=off)",
    0
};

static void
init_help_array(void)
{
  gengetopt_args_info_help[0] = gengetopt_args_info_full_help[0];
  gengetopt_args_info_help[1] = gengetopt_args_info_full_help[1];
  gengetopt_args_info_help[2] = gengetopt_args_info_full_help[2];
  gengetopt_args_info_help[3] = gengetopt_args_info_full_help[3];
  gengetopt_args_info_help[4] = gengetopt_args_info_full_help[4];
  gengetopt_args_info_help[5] = gengetopt_args_info_full_help[5];
  gengetopt_args_info_help[6] = gengetopt_args_info_full_help[8];
  gengetopt_args_info_help[7] = gengetopt_args_info_full_help[9];
  gengetopt_args_info_help[8] = gengetopt_args_info_full_help[10];
  gengetopt_args_info_help[9] = gengetopt_args_info_full_help[11];
  gengetopt_args_info_help[10] = gengetopt_args_info_full_help[12];
  gengetopt_args_info_help[11] = gengetopt_args_info_full_help[13];
  gengetopt_args_info_help[12] = gengetopt_args_info_full_help[14];
  gengetopt_args_info_help[13] = gengetopt_args_info_full_help[15];
  gengetopt_args_info_help[14] = gengetopt_args_info_full_help[16];
  gengetopt_args_info_help[15] = gengetopt_args_info_full_help[17];
  gengetopt_args_info_help[16] = gengetopt_args_info_full_help[18];
  gengetopt_args_info_help[17] = gengetopt_args_info_full_help[19];
  gengetopt_args_info_help[18] = 0; 
  
}

const char *gengetopt_args_info_help[19];

typedef enum {ARG_NO
  , ARG_FLAG
  , ARG_STRING
} cmdline_parser_arg_type;

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error);

static int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error);

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->full_help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->input_given = 0 ;
  args_info->output_given = 0 ;
  args_info->fail_given = 0 ;
  args_info->only_fail_given = 0 ;
  args_info->no_fail_given = 0 ;
  args_info->copy_given = 0 ;
  args_info->process_given = 0 ;
  args_info->select_given = 0 ;
  args_info->ignore_given = 0 ;
  args_info->output_field_given = 0 ;
  args_info->input_field_given = 0 ;
  args_info->interactive_given = 0 ;
  args_info->config_given = 0 ;
  args_info->one_field_given = 0 ;
  args_info->one_line_given = 0 ;
  args_info->language_given = 0 ;
  args_info->color_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->input_arg = NULL;
  args_info->input_orig = NULL;
  args_info->output_arg = NULL;
  args_info->output_orig = NULL;
  args_info->fail_arg = NULL;
  args_info->fail_orig = NULL;
  args_info->only_fail_flag = 0;
  args_info->no_fail_flag = 0;
  args_info->copy_flag = 0;
  args_info->process_arg = NULL;
  args_info->process_orig = NULL;
  args_info->select_arg = NULL;
  args_info->select_orig = NULL;
  args_info->ignore_arg = NULL;
  args_info->ignore_orig = NULL;
  args_info->output_field_arg = NULL;
  args_info->output_field_orig = NULL;
  args_info->input_field_arg = NULL;
  args_info->input_field_orig = NULL;
  args_info->interactive_flag = 0;
  args_info->config_arg = NULL;
  args_info->config_orig = NULL;
  args_info->one_field_flag = 0;
  args_info->one_line_flag = 0;
  args_info->language_arg = NULL;
  args_info->language_orig = NULL;
  args_info->color_flag = 0;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{

  init_help_array(); 
  args_info->help_help = gengetopt_args_info_full_help[0] ;
  args_info->full_help_help = gengetopt_args_info_full_help[1] ;
  args_info->version_help = gengetopt_args_info_full_help[2] ;
  args_info->input_help = gengetopt_args_info_full_help[3] ;
  args_info->output_help = gengetopt_args_info_full_help[4] ;
  args_info->fail_help = gengetopt_args_info_full_help[5] ;
  args_info->only_fail_help = gengetopt_args_info_full_help[6] ;
  args_info->no_fail_help = gengetopt_args_info_full_help[7] ;
  args_info->copy_help = gengetopt_args_info_full_help[8] ;
  args_info->process_help = gengetopt_args_info_full_help[9] ;
  args_info->process_min = 0;
  args_info->process_max = 0;
  args_info->select_help = gengetopt_args_info_full_help[10] ;
  args_info->select_min = 0;
  args_info->select_max = 0;
  args_info->ignore_help = gengetopt_args_info_full_help[11] ;
  args_info->ignore_min = 0;
  args_info->ignore_max = 0;
  args_info->output_field_help = gengetopt_args_info_full_help[12] ;
  args_info->input_field_help = gengetopt_args_info_full_help[13] ;
  args_info->input_field_min = 0;
  args_info->input_field_max = 0;
  args_info->interactive_help = gengetopt_args_info_full_help[14] ;
  args_info->config_help = gengetopt_args_info_full_help[15] ;
  args_info->one_field_help = gengetopt_args_info_full_help[16] ;
  args_info->one_line_help = gengetopt_args_info_full_help[17] ;
  args_info->language_help = gengetopt_args_info_full_help[18] ;
  args_info->color_help = gengetopt_args_info_full_help[19] ;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(CMDLINE_PARSER_PACKAGE_NAME) ? CMDLINE_PARSER_PACKAGE_NAME : CMDLINE_PARSER_PACKAGE),
     CMDLINE_PARSER_VERSION);
}

static void print_help_common(void) {
  cmdline_parser_print_version ();

  if (strlen(gengetopt_args_info_purpose) > 0)
    printf("\n%s\n", gengetopt_args_info_purpose);

  if (strlen(gengetopt_args_info_usage) > 0)
    printf("\n%s\n", gengetopt_args_info_usage);

  printf("\n");

  if (strlen(gengetopt_args_info_description) > 0)
    printf("%s\n\n", gengetopt_args_info_description);
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_print_full_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_full_help[i])
    printf("%s\n", gengetopt_args_info_full_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);
}

void
cmdline_parser_params_init(struct cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct cmdline_parser_params *
cmdline_parser_params_create(void)
{
  struct cmdline_parser_params *params = 
    (struct cmdline_parser_params *)malloc(sizeof(struct cmdline_parser_params));
  cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}

/** @brief generic value variable */
union generic_value {
    char *string_arg;
    const char *default_string_arg;
};

/** @brief holds temporary values for multiple options */
struct generic_list
{
  union generic_value arg;
  char *orig;
  struct generic_list *next;
};

/**
 * @brief add a node at the head of the list 
 */
static void add_node(struct generic_list **list) {
  struct generic_list *new_node = (struct generic_list *) malloc (sizeof (struct generic_list));
  new_node->next = *list;
  *list = new_node;
  new_node->arg.string_arg = 0;
  new_node->orig = 0;
}


static void
free_multiple_string_field(unsigned int len, char ***arg, char ***orig)
{
  unsigned int i;
  if (*arg) {
    for (i = 0; i < len; ++i)
      {
        free_string_field(&((*arg)[i]));
        free_string_field(&((*orig)[i]));
      }
    free_string_field(&((*arg)[0])); /* free default string */

    free (*arg);
    *arg = 0;
    free (*orig);
    *orig = 0;
  }
}

static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{

  free_string_field (&(args_info->input_arg));
  free_string_field (&(args_info->input_orig));
  free_string_field (&(args_info->output_arg));
  free_string_field (&(args_info->output_orig));
  free_string_field (&(args_info->fail_arg));
  free_string_field (&(args_info->fail_orig));
  free_multiple_string_field (args_info->process_given, &(args_info->process_arg), &(args_info->process_orig));
  free_multiple_string_field (args_info->select_given, &(args_info->select_arg), &(args_info->select_orig));
  free_multiple_string_field (args_info->ignore_given, &(args_info->ignore_arg), &(args_info->ignore_orig));
  free_string_field (&(args_info->output_field_arg));
  free_string_field (&(args_info->output_field_orig));
  free_multiple_string_field (args_info->input_field_given, &(args_info->input_field_arg), &(args_info->input_field_orig));
  free_string_field (&(args_info->config_arg));
  free_string_field (&(args_info->config_orig));
  free_string_field (&(args_info->language_arg));
  free_string_field (&(args_info->language_orig));
  
  

  clear_given (args_info);
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  FIX_UNUSED (values);
  if (arg) {
    fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}

static void
write_multiple_into_file(FILE *outfile, int len, const char *opt, char **arg, const char *values[])
{
  int i;
  
  for (i = 0; i < len; ++i)
    write_into_file(outfile, opt, (arg ? arg[i] : 0), values);
}

int
cmdline_parser_dump(FILE *outfile, struct gengetopt_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->full_help_given)
    write_into_file(outfile, "full-help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->input_given)
    write_into_file(outfile, "input", args_info->input_orig, 0);
  if (args_info->output_given)
    write_into_file(outfile, "output", args_info->output_orig, 0);
  if (args_info->fail_given)
    write_into_file(outfile, "fail", args_info->fail_orig, 0);
  if (args_info->only_fail_given)
    write_into_file(outfile, "only-fail", 0, 0 );
  if (args_info->no_fail_given)
    write_into_file(outfile, "no-fail", 0, 0 );
  if (args_info->copy_given)
    write_into_file(outfile, "copy", 0, 0 );
  write_multiple_into_file(outfile, args_info->process_given, "process", args_info->process_orig, 0);
  write_multiple_into_file(outfile, args_info->select_given, "select", args_info->select_orig, 0);
  write_multiple_into_file(outfile, args_info->ignore_given, "ignore", args_info->ignore_orig, 0);
  if (args_info->output_field_given)
    write_into_file(outfile, "output-field", args_info->output_field_orig, 0);
  write_multiple_into_file(outfile, args_info->input_field_given, "input-field", args_info->input_field_orig, 0);
  if (args_info->interactive_given)
    write_into_file(outfile, "interactive", 0, 0 );
  if (args_info->config_given)
    write_into_file(outfile, "config", args_info->config_orig, 0);
  if (args_info->one_field_given)
    write_into_file(outfile, "one-field", 0, 0 );
  if (args_info->one_line_given)
    write_into_file(outfile, "one-line", 0, 0 );
  if (args_info->language_given)
    write_into_file(outfile, "language", args_info->language_orig, 0);
  if (args_info->color_given)
    write_into_file(outfile, "color", 0, 0 );
  

  i = EXIT_SUCCESS;
  return i;
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

static char *
get_multiple_arg_token(const char *arg)
{
  const char *tok;
  char *ret;
  size_t len, num_of_escape, i, j;

  if (!arg)
    return 0;

  tok = strchr (arg, ',');
  num_of_escape = 0;

  /* make sure it is not escaped */
  while (tok)
    {
      if (*(tok-1) == '\\')
        {
          /* find the next one */
          tok = strchr (tok+1, ',');
          ++num_of_escape;
        }
      else
        break;
    }

  if (tok)
    len = (size_t)(tok - arg + 1);
  else
    len = strlen (arg) + 1;

  len -= num_of_escape;

  ret = (char *) malloc (len);

  i = 0;
  j = 0;
  while (arg[i] && (j < len-1))
    {
      if (arg[i] == '\\' && 
	  arg[ i + 1 ] && 
	  arg[ i + 1 ] == ',')
        ++i;

      ret[j++] = arg[i++];
    }

  ret[len-1] = '\0';

  return ret;
}

static const char *
get_multiple_arg_token_next(const char *arg)
{
  const char *tok;

  if (!arg)
    return 0;

  tok = strchr (arg, ',');

  /* make sure it is not escaped */
  while (tok)
    {
      if (*(tok-1) == '\\')
        {
          /* find the next one */
          tok = strchr (tok+1, ',');
        }
      else
        break;
    }

  if (! tok || strlen(tok) == 1)
    return 0;

  return tok+1;
}

static int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc);

int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc)
{
  int error = 0;

  if (option_given && (min > 0 || max > 0))
    {
      if (min > 0 && max > 0)
        {
          if (min == max)
            {
              /* specific occurrences */
              if (option_given != (unsigned int) min)
                {
                  fprintf (stderr, "%s: %s option occurrences must be %d\n",
                    prog_name, option_desc, min);
                  error = 1;
                }
            }
          else if (option_given < (unsigned int) min
                || option_given > (unsigned int) max)
            {
              /* range occurrences */
              fprintf (stderr, "%s: %s option occurrences must be between %d and %d\n",
                prog_name, option_desc, min, max);
              error = 1;
            }
        }
      else if (min > 0)
        {
          /* at least check */
          if (option_given < min)
            {
              fprintf (stderr, "%s: %s option occurrences must be at least %d\n",
                prog_name, option_desc, min);
              error = 1;
            }
        }
      else if (max > 0)
        {
          /* at most check */
          if (option_given > max)
            {
              fprintf (stderr, "%s: %s option occurrences must be at most %d\n",
                prog_name, option_desc, max);
              error = 1;
            }
        }
    }
    
  return error;
}
int
cmdline_parser (int argc, char **argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser_ext (int argc, char **argv, struct gengetopt_args_info *args_info,
                   struct cmdline_parser_params *params)
{
  int result;
  result = cmdline_parser_internal (argc, argv, args_info, params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser2 (int argc, char **argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = cmdline_parser_internal (argc, argv, args_info, &params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  int result = EXIT_SUCCESS;

  if (cmdline_parser_required2(args_info, prog_name, 0) > 0)
    result = EXIT_FAILURE;

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error)
{
  int error = 0;
  FIX_UNUSED (additional_error);

  /* checks for required options */
  if (check_multiple_option_occurrences(prog_name, args_info->process_given, args_info->process_min, args_info->process_max, "'--process' ('-p')"))
     error = 1;
  
  if (check_multiple_option_occurrences(prog_name, args_info->select_given, args_info->select_min, args_info->select_max, "'--select' ('-s')"))
     error = 1;
  
  if (check_multiple_option_occurrences(prog_name, args_info->ignore_given, args_info->ignore_min, args_info->ignore_max, "'--ignore' ('-S')"))
     error = 1;
  
  if (check_multiple_option_occurrences(prog_name, args_info->input_field_given, args_info->input_field_min, args_info->input_field_max, "'--input-field' ('-I')"))
     error = 1;
  
  
  /* checks for dependences among options */

  return error;
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see cmdline_parser_params.check_ambiguity
 * @param override @see cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  FIX_UNUSED (default_value);
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_FLAG:
    *((int *)field) = !*((int *)field);
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };


  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
  case ARG_FLAG:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}

/**
 * @brief store information about a multiple option in a temporary list
 * @param list where to (temporarily) store multiple options
 */
static
int update_multiple_arg_temp(struct generic_list **list,
               unsigned int *prev_given, const char *val,
               const char *possible_values[], const char *default_value,
               cmdline_parser_arg_type arg_type,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  /* store single arguments */
  char *multi_token;
  const char *multi_next;

  if (arg_type == ARG_NO) {
    (*prev_given)++;
    return 0; /* OK */
  }

  multi_token = get_multiple_arg_token(val);
  multi_next = get_multiple_arg_token_next (val);

  while (1)
    {
      add_node (list);
      if (update_arg((void *)&((*list)->arg), &((*list)->orig), 0,
          prev_given, multi_token, possible_values, default_value, 
          arg_type, 0, 1, 1, 1, long_opt, short_opt, additional_error)) {
        if (multi_token) free(multi_token);
        return 1; /* failure */
      }

      if (multi_next)
        {
          multi_token = get_multiple_arg_token(multi_next);
          multi_next = get_multiple_arg_token_next (multi_next);
        }
      else
        break;
    }

  return 0; /* OK */
}

/**
 * @brief free the passed list (including possible string argument)
 */
static
void free_list(struct generic_list *list, short string_arg)
{
  if (list) {
    struct generic_list *tmp;
    while (list)
      {
        tmp = list;
        if (string_arg && list->arg.string_arg)
          free (list->arg.string_arg);
        if (list->orig)
          free (list->orig);
        list = list->next;
        free (tmp);
      }
  }
}

/**
 * @brief updates a multiple option starting from the passed list
 */
static
void update_multiple_arg(void *field, char ***orig_field,
               unsigned int field_given, unsigned int prev_given, union generic_value *default_value,
               cmdline_parser_arg_type arg_type,
               struct generic_list *list)
{
  int i;
  struct generic_list *tmp;

  if (prev_given && list) {
    *orig_field = (char **) realloc (*orig_field, (field_given + prev_given) * sizeof (char *));

    switch(arg_type) {
    case ARG_STRING:
      *((char ***)field) = (char **)realloc (*((char ***)field), (field_given + prev_given) * sizeof (char *)); break;
    default:
      break;
    };
    
    for (i = (prev_given - 1); i >= 0; --i)
      {
        tmp = list;
        
        switch(arg_type) {
        case ARG_STRING:
          (*((char ***)field))[i + field_given] = tmp->arg.string_arg; break;
        default:
          break;
        }        
        (*orig_field) [i + field_given] = list->orig;
        list = list->next;
        free (tmp);
      }
  } else { /* set the default value */
    if (default_value && ! field_given) {
      switch(arg_type) {
      case ARG_STRING:
        if (! *((char ***)field)) {
          *((char ***)field) = (char **)malloc (sizeof (char *));
          (*((char ***)field))[0] = gengetopt_strdup(default_value->string_arg);
        }
        break;
      default: break;
      }
      if (!(*orig_field)) {
        *orig_field = (char **) malloc (sizeof (char *));
        (*orig_field)[0] = 0;
      }
    }
  }
}

int
cmdline_parser_internal (
  int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  struct generic_list * process_list = NULL;
  struct generic_list * select_list = NULL;
  struct generic_list * ignore_list = NULL;
  struct generic_list * input_field_list = NULL;
  int error = 0;
  struct gengetopt_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;
  
  package_name = argv[0];
  
  override = params->override;
  initialize = params->initialize;
  check_required = params->check_required;
  check_ambiguity = params->check_ambiguity;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "full-help",	0, NULL, 0 },
        { "version",	0, NULL, 'V' },
        { "input",	1, NULL, 'f' },
        { "output",	1, NULL, 'o' },
        { "fail",	1, NULL, 'e' },
        { "only-fail",	0, NULL, 0 },
        { "no-fail",	0, NULL, 0 },
        { "copy",	0, NULL, 'c' },
        { "process",	1, NULL, 'p' },
        { "select",	1, NULL, 's' },
        { "ignore",	1, NULL, 'S' },
        { "output-field",	1, NULL, 'O' },
        { "input-field",	1, NULL, 'I' },
        { "interactive",	0, NULL, 'i' },
        { "config",	1, NULL, 0 },
        { "one-field",	0, NULL, '1' },
        { "one-line",	0, NULL, 0 },
        { "language",	1, NULL, 0 },
        { "color",	0, NULL, 'l' },
        { 0,  0, 0, 0 }
      };

      c = getopt_long (argc, argv, "hVf:o:e:cp:s:S:O:I:i1l", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'f':	/* Input file.  */
        
        
          if (update_arg( (void *)&(args_info->input_arg), 
               &(args_info->input_orig), &(args_info->input_given),
              &(local_args_info.input_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "input", 'f',
              additional_error))
            goto failure;
        
          break;
        case 'o':	/* Output file for succesfully processed segments.  */
        
        
          if (update_arg( (void *)&(args_info->output_arg), 
               &(args_info->output_orig), &(args_info->output_given),
              &(local_args_info.output_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "output", 'o',
              additional_error))
            goto failure;
        
          break;
        case 'e':	/* Output file for unsuccesfully processed segments .  */
        
        
          if (update_arg( (void *)&(args_info->fail_arg), 
               &(args_info->fail_orig), &(args_info->fail_given),
              &(local_args_info.fail_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "fail", 'e',
              additional_error))
            goto failure;
        
          break;
        case 'c':	/* Copy succesfully processed segments to standard output.  */
        
        
          if (update_arg((void *)&(args_info->copy_flag), 0, &(args_info->copy_given),
              &(local_args_info.copy_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "copy", 'c',
              additional_error))
            goto failure;
        
          break;
        case 'p':	/* Process segments with this tag.  */
        
          if (update_multiple_arg_temp(&process_list, 
              &(local_args_info.process_given), optarg, 0, 0, ARG_STRING,
              "process", 'p',
              additional_error))
            goto failure;
        
          break;
        case 's':	/* Select only segments with this field.  */
        
          if (update_multiple_arg_temp(&select_list, 
              &(local_args_info.select_given), optarg, 0, 0, ARG_STRING,
              "select", 's',
              additional_error))
            goto failure;
        
          break;
        case 'S':	/* Select only segments without this field.  */
        
          if (update_multiple_arg_temp(&ignore_list, 
              &(local_args_info.ignore_given), optarg, 0, 0, ARG_STRING,
              "ignore", 'S',
              additional_error))
            goto failure;
        
          break;
        case 'O':	/* Output field name.  */
        
        
          if (update_arg( (void *)&(args_info->output_field_arg), 
               &(args_info->output_field_orig), &(args_info->output_field_given),
              &(local_args_info.output_field_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "output-field", 'O',
              additional_error))
            goto failure;
        
          break;
        case 'I':	/* Input field name.  */
        
          if (update_multiple_arg_temp(&input_field_list, 
              &(local_args_info.input_field_given), optarg, 0, 0, ARG_STRING,
              "input-field", 'I',
              additional_error))
            goto failure;
        
          break;
        case 'i':	/* Toggle interactive mode.  */
        
        
          if (update_arg((void *)&(args_info->interactive_flag), 0, &(args_info->interactive_given),
              &(local_args_info.interactive_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "interactive", 'i',
              additional_error))
            goto failure;
        
          break;
        case '1':	/* Print all results in one segments (creates ambiguous annotation).  */
        
        
          if (update_arg((void *)&(args_info->one_field_flag), 0, &(args_info->one_field_given),
              &(local_args_info.one_field_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "one-field", '1',
              additional_error))
            goto failure;
        
          break;
        case 'l':	/* Show guessed descriptions in colour..  */
        
        
          if (update_arg((void *)&(args_info->color_flag), 0, &(args_info->color_given),
              &(local_args_info.color_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "color", 'l',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
          if (strcmp (long_options[option_index].name, "full-help") == 0) {
            cmdline_parser_print_full_help ();
            cmdline_parser_free (&local_args_info);
            exit (EXIT_SUCCESS);
          }

          /* Print only segments the program failed to process.  */
          if (strcmp (long_options[option_index].name, "only-fail") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->only_fail_flag), 0, &(args_info->only_fail_given),
                &(local_args_info.only_fail_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "only-fail", '-',
                additional_error))
              goto failure;
          
          }
          /* Print only segments the program processed.  */
          else if (strcmp (long_options[option_index].name, "no-fail") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->no_fail_flag), 0, &(args_info->no_fail_given),
                &(local_args_info.no_fail_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "no-fail", '-',
                additional_error))
              goto failure;
          
          }
          /* Configuration file.  */
          else if (strcmp (long_options[option_index].name, "config") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->config_arg), 
                 &(args_info->config_orig), &(args_info->config_given),
                &(local_args_info.config_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "config", '-',
                additional_error))
              goto failure;
          
          }
          /* Print annotation alternatives as additional fields.  */
          else if (strcmp (long_options[option_index].name, "one-line") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->one_line_flag), 0, &(args_info->one_line_given),
                &(local_args_info.one_line_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "one-line", '-',
                additional_error))
              goto failure;
          
          }
          /* Language..  */
          else if (strcmp (long_options[option_index].name, "language") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->language_arg), 
                 &(args_info->language_orig), &(args_info->language_given),
                &(local_args_info.language_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "language", '-',
                additional_error))
              goto failure;
          
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */


  update_multiple_arg((void *)&(args_info->process_arg),
    &(args_info->process_orig), args_info->process_given,
    local_args_info.process_given, 0,
    ARG_STRING, process_list);
  update_multiple_arg((void *)&(args_info->select_arg),
    &(args_info->select_orig), args_info->select_given,
    local_args_info.select_given, 0,
    ARG_STRING, select_list);
  update_multiple_arg((void *)&(args_info->ignore_arg),
    &(args_info->ignore_orig), args_info->ignore_given,
    local_args_info.ignore_given, 0,
    ARG_STRING, ignore_list);
  update_multiple_arg((void *)&(args_info->input_field_arg),
    &(args_info->input_field_orig), args_info->input_field_given,
    local_args_info.input_field_given, 0,
    ARG_STRING, input_field_list);

  args_info->process_given += local_args_info.process_given;
  local_args_info.process_given = 0;
  args_info->select_given += local_args_info.select_given;
  local_args_info.select_given = 0;
  args_info->ignore_given += local_args_info.ignore_given;
  local_args_info.ignore_given = 0;
  args_info->input_field_given += local_args_info.input_field_given;
  local_args_info.input_field_given = 0;
  
  if (check_required)
    {
      error += cmdline_parser_required2 (args_info, argv[0], additional_error);
    }

  cmdline_parser_release (&local_args_info);

  if ( error )
    return (EXIT_FAILURE);

  return 0;

failure:
  free_list (process_list, 1 );
  free_list (select_list, 1 );
  free_list (ignore_list, 1 );
  free_list (input_field_list, 1 );
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
