#include "lem.h"
#include <cstdlib>
#include <cassert>

/* Znajduje opisy slownikowe dla wyrazu.
 * Parametry:
 * form - wyraz,
 * tab - referencja do tablicy Words (miejsce na wyniki)
 * Wartosc:
 * liczba dodanych opisow
 */
int Lem::ana(const wchar_t* form, Words& tab) {
  assert(form && &tab);
  int count0 = tab.count();
  LemFST::State l,d;
  int i = 0;
  LemFST::Word w = *LemFST::charToWord(form);
  d = _dict.next(_dict.start(), w);
  d = _dict.next(d, ';');

  if (d>=0)
    add_to_table(tab, form, d);
  return tab.count()-count0;
}



/* Dodaje kolejne opisy do tablicy wynikow.
 * Parametry:
 * tab - tablica wynikow,
 * f - wyraz,
 * s - stan, na ktorym zaczyna sie pierwszy opis
 */
void Lem::add_to_table(Words& tab, const wchar_t* f, LemFST::State s) {
  assert(&tab);
  assert(f);
  
  LemFST::Word *w = new LemFST::Word();
  int r;
  while (r = _dict.cont(s, w, 200)) {
	char fchar[200]; //Bufor do przetrzymywania f w postaci zwyklych char 
	wcstombs(fchar, f, 200); // Zamien f w zwykle chary i umiesc w fchar
	const char* wChar = LemFST::wordToChar(w); // Aktualne slowo zamien w chary
	w->clear(); // czyscimy bufor ze slowem.
	tab.add(fchar, wChar);
   }
   _dict.cont(LemFST::noStateId, w, 200); // ubijamy generator
   delete w;
}

void Lem::prn_dict()
{
  LemFST::Word des;
  LemFST::State s=_dict.start();

  while (_dict.cont(s, &des, 200))
    {
      wprintf(L"%ls\n",des.size()); // Ladne drukowanie!
      s=-1;
	// TODO: Ladne wyswiatlanie slownika; 
    }
}











//======================================================================
// AUX LEM
//======================================================================
AuxLem::AuxLem(const char* filename)
        : Lem(filename), _dict(SIZE)
{
  FILE* f;
  char buf[MAX_LINE+2];
  f=fopen(filename,"r");
  for(long i=0; i<SIZE; ++i) info[i]=(char*)NULL;
  while(fgets(buf,MAX_LINE,f))
  {
    int l=strlen(buf);
    if(l>=MAX_LINE-1) continue; // BEZ isalpha!
    buf[l-1]='\0';
    char* sep=strchr(buf,';');
    if(sep==NULL) continue;
    *sep='\0';
    long formind=_dict.add(buf);
    if(formind>=0)
    {
      char* desc=strdup(sep+1);
      info[formind]=desc;
    }
    else
      fprintf(stderr,"AuxLem: Form not added: %s;%s.\n", buf,sep+1);
  }
  fclose(f);
};


AuxLem::~AuxLem()
{
  for(long i=0; i<SIZE; ++i)
    if(info[i]) free(info[i]);
}


int AuxLem::ana(const char* form, Words& tab)
{
  if(!form) return 0;
  int count0=tab.count();
  char des[MAX_LINE];
  long ind=_dict[form];
  if(ind>=0)
  {
    strcpy(des,info[ind]);
    char* des1;
    if((des1=strtok(des,";"))!=NULL)
      do
      {
        if(tab.cnt>=MAXALT) break;
        tab.add(form,des1);
        des1=strtok(NULL,";");
      } while(des1!=NULL);
  }
  return tab.count()-count0;
}


