#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <regex.h>

char buf[5000];

int main(int argc, char **argv)
{

  char *pattern;
  char eoln;
  regex_t re;

  int firstline = 1;

  if( argc < 2 )
  {
/*     pattern="[ \t]*([0-9]+[ \t]+){2}EOS([ \t].*)?"; */
    pattern = "[ \t]*BOS([ \t].*)?";
  }
  else
  {
    pattern = argv[1];
  }

  if( argc < 3 )
  {
    eoln = '\f';
  }
  else
  {
    eoln = atoi(argv[2]);
  }

  if( 0 != regcomp(&re, pattern, REG_EXTENDED|REG_NOSUB) )
  {
    fprintf(stderr, "Invalid pattern.\n");
    return 1;
  }

  while( fgets(buf, 5000, stdin) )
  {
    buf[strlen(buf)-1] = '\0';
    if( firstline )
    {
      firstline = 0;
    }
    else
    {
      if( 0 == regexec(&re, buf, (size_t)0, NULL, 0) )
      {
        putchar('\n');
      }
      else
      {
        putchar(eoln);
      }
    }
    fputs(buf, stdout);
  }

  putchar('\n');

  return 0;

}

