#ifndef _HashTable_h
#define _HashTable_h
//---------------------------------------------------------------------------
#include <cstddef>
#include <cstring>
//---------------------------------------------------------------------------
int hash1(const char* s, int sz);
int hash2(const char* s, int sz);
//---------------------------------------------------------------------------
namespace UTT {
class SymbolTable
{
  int _mx;
  int _sz;
  int _cnt;
  char** _key;
  char** _def;
  int* _defind;
  int* _hashind;        // s tu redundancje

public:
  static const unsigned int MAXKEYLEN=2000;

  SymbolTable(int n, int (*h)(const char*,int), const char* filename=NULL);
  SymbolTable(int n, const char* filename=NULL);
  ~SymbolTable();

  void clear();

  int (*hash)(const char*, int);

  bool add_from_file(const char* filename);

  int add(const char* s);
  int operator[](const char* s);
  const char* operator[](int i){if(i<0||i>=_cnt)return NULL;else return _def[i];}
  int index(const char* s) { return this->operator[](s); };
  int index(int i) { if(i<0||i>=_cnt) return -1; else return i; };
  int hash_index(int i) { return _hashind[i]; }
  const char* symbol(int i) { if(i<0||i>=_cnt)return NULL; else return _def[i];}

  int capacity() { return _mx; }
  int size() { return _sz; }
  int count() { return _cnt; }
  float search_rate();

private:
  static int first(unsigned int n);
};
}
//---------------------------------------------------------------------------
#endif
