#include "../lib/iotools.h"
//do wyrzucenia - definicja w Makefile! #define _CMDLINE_FILE "../lem/cmdline.h"
#include "../common/common.h"
#include "common_lem.h"
#include "lem.h"
#include "cmdline.h"
#include <cwchar>
#include <clocale>
#include <wctype.h>

int main(int argc, char** argv) {

   setlocale(LC_CTYPE,"");

  gengetopt_args_info args;

  if(cmdline_parser(argc, argv, &args) != 0)
    exit(1);

  process_config_files(&args,argv[0]);
  process_common_options(&args,argv[0]);
  process_lem_options(&args);
  
  wchar_t line[MAX_LINE+1];
  wchar_t outline[MAX_LINE+1];
  wchar_t parms[MAX_LINE+1], desc[MAX_LINE+1], lemma[MAX_LINE+1];
  long line_count = 0;

  Lem* lem;
  
  if(strcmp(dictionary+strlen(dictionary)-4,".bin")==0)
    lem = new Lem(dictionary);
  else if(strcmp(dictionary+strlen(dictionary)-4,".dic")==0)
    lem = new AuxLem(dictionary);
  else
    fprintf(stderr,"lem: Invalid dictionary file extension.\n");
  
  Words tab;
//   Segment seg;

  while (fgetws(line, MAX_LINE, inputf))
  {
      ++line_count;
      int start, len;
     
      char linechar[MAX_LINE+1];
      wcstombs(linechar, line, MAX_LINE+1);
      if (!process_seg(linechar, args)) // TO POWINNO BYC WCZESNIEJ ZABEZPIECZONE
	      fputws(line, outputf);
      else
	    {
	      wchar_t form[MAX_FORM+1];

	      tab.clear();
        	wchar_t winput_field_prefix[MAX_LINE+1];
        	mbstowcs(winput_field_prefix, input_field_prefix, MAX_LINE+1);
	     	getfield(line,winput_field_prefix,form); /// SEGMENTATION FAULT!!!
		/* W trakcie uzupelniania pola "4" nastepuje cos dziwnego... */
	      if (form==NULL) continue;//BZDURA
	      lem->ana(form, tab);
	      if(tab.count()==0)
	      {
		          
	        wchar_t form1[MAX_FORM]; // tymczasowo tak, trzeba zmienic ana
	        wchar_t* p;
	        wcscpy(form1,form);
	        for(p=form1;*p;++p) *p=towlower(*p);
	        p=form1;
	        lem->ana(p,tab);
	      }
	      if (tab.count() == 0) {
	        fputws(line, failedf);
       		 }
      
	      else 
	      { // mamy jakies opisy w slowniku
	        if(one_line)
		      {
		        wchar_t* descp=desc;
            //wchar_t woutput_field_prefix[MAX_LINE+1];
            //mbstowcs(woutput_field_prefix, output_field_prefix, MAX_LINE+1);
		        wprintf(L"tab.count() in one-line: %d prefix: %s", tab.count(), output_field_prefix);
            for (int i=0; i< tab.count(); ++i)
		        {
		          descp += swprintf(descp,MAX_LINE, L" %s%s,%s", output_field_prefix, tab[i].lemma(), tab[i].descr());
              wprintf(L"for %d lemma '%s' descr '%s'", i, tab[i].lemma(), tab[i].descr());
		        }
            wprintf(L"descp: %ls", descp);
		        wcscpy(outline,line);
		        outline[wcslen(outline)-1]='\0';
	      		wcscat(outline,descp);
		        wcscat(outline,L"\n");
      			fputws(outline, outputf);
		        if (copy_processed)
      			    fputws(line,outputf);
		      }
	        else if(one_field)
		      {
      		  wchar_t* descp=desc;
      		  for (int i=0; i< tab.count(); ++i)
		          if(i==0)
      		      descp += swprintf(descp,MAX_LINE,L" %s%s,%s", output_field_prefix, tab[i].lemma(), tab[i].descr());
		          else
		          {
        	  		if(strcmp(tab[i].lemma(),tab[i-1].lemma())==0)
          			  descp += swprintf(descp,MAX_LINE,L",%s",tab[i].descr());
          			else
          			  descp += swprintf(descp,MAX_LINE,L";%s,%s",tab[i].lemma(),tab[i].descr());
    		      }
		 	 
		          wcscpy(outline,line);
			wprintf(L"%ls \n", line);
          	  outline[wcslen(outline)-1]=L'\0';
        		  wcscat(outline,desc);
        		  wcscat(outline,L"\n");
        		  fputws(outline, outputf);
        		  
              if (copy_processed)  fputws(line,outputf);
		      }
          else
		      {
			  for (int i=0; i< tab.count(); ++i)
				{
				      swprintf(desc,MAX_LINE,L" %s%s,%s \n", output_field_prefix, tab[i].lemma(), tab[i].descr());
				      wcscpy(outline,line);
				      outline[wcslen(outline)-1]='\0';
				      wcscat(outline,desc);
				      fputws(outline, outputf);
				}
			  if (copy_processed) fputws(line,outputf);
		      }
	      } 
	    }
      
      if (args.interactive_flag) 
    	  fflush(outputf), fflush(failedf);
      
    }
    cmdline_parser_free(&args);
}
