#include "lem.h"
#include <cstdlib>
#include <cassert>


/* Znajduje opisy slownikowe dla wyrazu.
 * Parametry:
 * form - wyraz,
 * tab - referencja do tablicy Words (miejsce na wyniki)
 * Wartosc:
 * liczba dodanych opisow
 */
int Lem::ana(const char* form, Words& tab) {

  // sprawdzamy czy parametry wywolania sa poprawne
  assert(form && &tab);
  int count0 = tab.count();
  long l;
  if ((l=_dict.next(_dict.gtra(0, form, FT::ftMAXPATH), ';'))>=0)
    add_to_table(tab, form, l);
  return tab.count()-count0;
}


/* Szukamy opisu slownikowego nastepnego wyrazu w buforze.
 * Parametry:
 * buf - bufor
 * tab - miejsce na wyniki
 * Wartosc:
 * ilosc dodanych opisow
 */
int Lem::pref(char* buf, Words& tab) {

  // sprawdzamy czy parametry wywolania sa poprawne
  assert(buf && &tab);

  int count0 = tab.count();
  long l;
  char* buf0 = buf;

  if((l=_dict.pref(buf, ';'))>=0) {
    char form[MAX_FORM];
    int len=buf-buf0;
    form[len]='\0';
    add_to_table(tab,form,l);
  }
  return tab.count() - count0;
}

/* Dodaje kolejne opisy do tablicy wynikow.
 * Parametry:
 * tab - tablica wynikow,
 * f - wyraz,
 * s - stan, na ktorym zaczyna sie pierwszy opis
 */
void Lem::add_to_table(Words& tab, const char* f, long s) {

  // sprawdzenie parametrow
  assert(&tab);
  assert(f);

  char des[FT::ftMAXPATH];

  while (_dict.cont(s, des)) {
    char* des1;
    if ((des1=strtok(des, ";")) != NULL)
      do {
	if (tab.count() >= MAX_ALT) break;
	tab.add(f, des1);
	des1=strtok(NULL, ";");
      } while (des1!=NULL);
    s=-1;
  }
}

void Lem::prn_dict()
{
 
  char des[FT::ftMAXPATH];

  long s=0;

  while (_dict.cont(s, des)) 
    {
      printf("%s\n",des);
      s=-1;
    }
}


AuxLem::AuxLem(const char* filename)
        : Lem(), _dict(SIZE)
{
  FILE* f;
  char buf[MAX_LINE+2];
  f=fopen(filename,"r");
  for(long i=0; i<SIZE; ++i) info[i]=(char*)NULL;
  while(fgets(buf,MAX_LINE,f))
  {
    int l=strlen(buf);
    if(l>=MAX_LINE-1) continue; // BEZ isalpha!
    buf[l-1]='\0';
    char* sep=strchr(buf,';');
    if(sep==NULL) continue;
    *sep='\0';
    long formind=_dict.add(buf);
    if(formind>=0)
    {
      char* desc=strdup(sep+1);
      info[formind]=desc;
    }
    else
      fprintf(stderr,"AuxLem: Form not added: %s;%s.\n", buf,sep+1);
  }
  fclose(f);
};

//---------------------------------------------------------------------------

AuxLem::~AuxLem()
{
//  for(long i=0; i<_dict.count(); ++i)
//    free(info[_dict.hashindex(i)]);
  for(long i=0; i<SIZE; ++i)
    if(info[i]) free(info[i]);
}

//---------------------------------------------------------------------------

int AuxLem::ana(const char* form, Words& tab)
{
  if(!form) return 0;
  int count0=tab.count();
  char des[MAX_LINE];
  long ind=_dict[form];
  if(ind>=0)
  {
    strcpy(des,info[ind]);
    char* des1;
    if((des1=strtok(des,";"))!=NULL)
      do
      {
        if(tab.cnt>=MAXALT) break;
        tab.add(form,des1);
        des1=strtok(NULL,";");
      } while(des1!=NULL);
  }
  return tab.count()-count0;
}

//---------------------------------------------------------------------------

