#include <stdlib.h>
#include <string.h>
#include "common_guess.h"

int guess_count=0;
double delta=0.1;
int cut_off=100;
char dictionary[255];
bool per_info=false;
bool weights=false;

void process_guess_options(gengetopt_args_info* args)
{

  if(args->dictionary_given)
    {
      expand_path(args->dictionary_arg,dictionary);
      if(file_accessible(dictionary)!=0)
	{
	  fprintf(stderr,"Cannot open the dictionary file: %s\nAborting.\n",dictionary);
	  exit(1);
	}
    }
  else if (args->dictionary_home_given && args->language_given)
    {
      char buf[255];
      expand_path(args->dictionary_home_arg, buf);
      sprintf(dictionary,"%s/%s/gue.bin",buf,args->language_arg);
      if(file_accessible(dictionary)!=0)
	{
	  fprintf(stderr,"Cannot open the dictionary file: %s\nAborting.\n",dictionary);
	  exit(1);
	}
    }

  if(args->guess_count_given)
    guess_count=args->guess_count_arg;
  else
    guess_count=0;

  if(guess_count==0)
    guess_count=100;

  if(args->delta_given)
    delta=args->delta_arg;
  else
    delta=0.1;

  if(args->cut_off_given)
    cut_off=args->cut_off_arg;
  else
    cut_off=100;

  if(args->per_info_given)
    per_info=args->per_info_flag;

  if(args->weights_given)
    weights=true;

}
