/** @file cmdline.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.22.4
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt by Lorenzo Bettini */

#ifndef CMDLINE_H
#define CMDLINE_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define CMDLINE_PARSER_PACKAGE "guess"
#endif

#ifndef CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#define CMDLINE_PARSER_PACKAGE_NAME "guess"
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION "0.1"
#endif

/** @brief Where the command line options are stored */
struct gengetopt_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *full_help_help; /**< @brief Print help, including hidden options, and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  char * input_arg;	/**< @brief Input file.  */
  char * input_orig;	/**< @brief Input file original value given at command line.  */
  const char *input_help; /**< @brief Input file help description.  */
  char * output_arg;	/**< @brief Output file for succesfully processed segments.  */
  char * output_orig;	/**< @brief Output file for succesfully processed segments original value given at command line.  */
  const char *output_help; /**< @brief Output file for succesfully processed segments help description.  */
  char * fail_arg;	/**< @brief Output file for unsuccesfully processed segments .  */
  char * fail_orig;	/**< @brief Output file for unsuccesfully processed segments  original value given at command line.  */
  const char *fail_help; /**< @brief Output file for unsuccesfully processed segments  help description.  */
  int only_fail_flag;	/**< @brief Print only segments the program failed to process (default=off).  */
  const char *only_fail_help; /**< @brief Print only segments the program failed to process help description.  */
  int no_fail_flag;	/**< @brief Print only segments the program processed (default=off).  */
  const char *no_fail_help; /**< @brief Print only segments the program processed help description.  */
  int copy_flag;	/**< @brief Copy succesfully processed segments to standard output (default=off).  */
  const char *copy_help; /**< @brief Copy succesfully processed segments to standard output help description.  */
  char ** process_arg;	/**< @brief Process segments with this tag.  */
  char ** process_orig;	/**< @brief Process segments with this tag original value given at command line.  */
  unsigned int process_min; /**< @brief Process segments with this tag's minimum occurreces */
  unsigned int process_max; /**< @brief Process segments with this tag's maximum occurreces */
  const char *process_help; /**< @brief Process segments with this tag help description.  */
  char ** select_arg;	/**< @brief Select only segments with this field.  */
  char ** select_orig;	/**< @brief Select only segments with this field original value given at command line.  */
  unsigned int select_min; /**< @brief Select only segments with this field's minimum occurreces */
  unsigned int select_max; /**< @brief Select only segments with this field's maximum occurreces */
  const char *select_help; /**< @brief Select only segments with this field help description.  */
  char ** ignore_arg;	/**< @brief Select only segments without this field.  */
  char ** ignore_orig;	/**< @brief Select only segments without this field original value given at command line.  */
  unsigned int ignore_min; /**< @brief Select only segments without this field's minimum occurreces */
  unsigned int ignore_max; /**< @brief Select only segments without this field's maximum occurreces */
  const char *ignore_help; /**< @brief Select only segments without this field help description.  */
  char * output_field_arg;	/**< @brief Output field name.  */
  char * output_field_orig;	/**< @brief Output field name original value given at command line.  */
  const char *output_field_help; /**< @brief Output field name help description.  */
  char ** input_field_arg;	/**< @brief Input field name.  */
  char ** input_field_orig;	/**< @brief Input field name original value given at command line.  */
  unsigned int input_field_min; /**< @brief Input field name's minimum occurreces */
  unsigned int input_field_max; /**< @brief Input field name's maximum occurreces */
  const char *input_field_help; /**< @brief Input field name help description.  */
  int interactive_flag;	/**< @brief Toggle interactive mode (default=off).  */
  const char *interactive_help; /**< @brief Toggle interactive mode help description.  */
  char * config_arg;	/**< @brief Configuration file.  */
  char * config_orig;	/**< @brief Configuration file original value given at command line.  */
  const char *config_help; /**< @brief Configuration file help description.  */
  int one_field_flag;	/**< @brief Print all results in one segments (creates ambiguous annotation) (default=off).  */
  const char *one_field_help; /**< @brief Print all results in one segments (creates ambiguous annotation) help description.  */
  int one_line_flag;	/**< @brief Print annotation alternatives as additional fields (default=off).  */
  const char *one_line_help; /**< @brief Print annotation alternatives as additional fields help description.  */
  char * language_arg;	/**< @brief Language..  */
  char * language_orig;	/**< @brief Language. original value given at command line.  */
  const char *language_help; /**< @brief Language. help description.  */
  int color_flag;	/**< @brief Show guessed descriptions in colour. (default=off).  */
  const char *color_help; /**< @brief Show guessed descriptions in colour. help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int full_help_given ;	/**< @brief Whether full-help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int input_given ;	/**< @brief Whether input was given.  */
  unsigned int output_given ;	/**< @brief Whether output was given.  */
  unsigned int fail_given ;	/**< @brief Whether fail was given.  */
  unsigned int only_fail_given ;	/**< @brief Whether only-fail was given.  */
  unsigned int no_fail_given ;	/**< @brief Whether no-fail was given.  */
  unsigned int copy_given ;	/**< @brief Whether copy was given.  */
  unsigned int process_given ;	/**< @brief Whether process was given.  */
  unsigned int select_given ;	/**< @brief Whether select was given.  */
  unsigned int ignore_given ;	/**< @brief Whether ignore was given.  */
  unsigned int output_field_given ;	/**< @brief Whether output-field was given.  */
  unsigned int input_field_given ;	/**< @brief Whether input-field was given.  */
  unsigned int interactive_given ;	/**< @brief Whether interactive was given.  */
  unsigned int config_given ;	/**< @brief Whether config was given.  */
  unsigned int one_field_given ;	/**< @brief Whether one-field was given.  */
  unsigned int one_line_given ;	/**< @brief Whether one-line was given.  */
  unsigned int language_given ;	/**< @brief Whether language was given.  */
  unsigned int color_given ;	/**< @brief Whether color was given.  */

} ;

/** @brief The additional parameters to pass to parser functions */
struct cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure gengetopt_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *gengetopt_args_info_usage;
/** @brief all the lines making the help output */
extern const char *gengetopt_args_info_help[];
/** @brief all the lines making the full help output (including hidden options) */
extern const char *gengetopt_args_info_full_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser (int argc, char **argv,
  struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
int cmdline_parser2 (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_ext (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_dump(FILE *outfile,
  struct gengetopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
void cmdline_parser_print_help(void);
/**
 * Print the full help (including hidden options)
 */
void cmdline_parser_print_full_help(void);
/**
 * Print the version
 */
void cmdline_parser_print_version(void);

/**
 * Initializes all the fields a cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void cmdline_parser_params_init(struct cmdline_parser_params *params);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized cmdline_parser_params structure
 */
struct cmdline_parser_params *cmdline_parser_params_create(void);

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* CMDLINE_H */
