divert(-1)
#--------------------------------------------------------------------------

# Macros defined here may be used in pattern specifications 
# You can modify this file according to your needs.

# ENDOFSEGMENT and MORFIELD are macros expanded to, respectively,
# end of segment marker (dependes on the format: flattened or not)
# and the name of the annotation field containing morphological
# information (standard value is 'lem'). These values are controlled
# by programs using this file to expand search patterns (ser, grp, ...).

# seg(type,form,annotation) 

define(`seg',`(\s*((\d+\s+)(\d+\s+)?)?dnl
ifelse($1, `',`(\S+)', `($1)')\s+dnl
ifelse($2, `',`(\S+)', `($2)')dnl
ifelse($3, `',`((\s+\S+)*)', `(\s+($3))')\s*ENDOFSEGMENT)')

# form(f) - segment containing the form f 

define(`form', `seg(,$1)')

# field(f) segment containing auxiliary field f 

define(`field', `seg(,,`(\S+\s+)*($1)(\s+\S+)*')')

# word, space, punct, number segments (assuming W, S, P, N segment types)

define(`space', `seg(`S',`$1')')
define(`word',  `seg(`W',`$1')')
define(`punct', `seg(`P',`$1')')
define(`number', `seg(`N',`$1')')

# macros specific to PMDB format 

define(`lexeme', `field(`MORFIELD:(\S+;)?$1,\S+')')
define(`cat', `field(`MORFIELD:\S+,$1([,;]\S+)?')')


# Place here your macro definitions. 









#--------------------------------------------------------------------------
divert(0)