#include <stdlib.h>
#include <string.h>
#include "common_lem.h"

char dictionary[255];

void process_lem_options(gengetopt_args_info* args)
{

  if(args->dictionary_given)
    {
      expand_path(args->dictionary_arg,dictionary);
      if(file_accessible(dictionary)!=0)
	{
	  fprintf(stderr,"Cannot open the dictionary file: %s\nAborting.\n",dictionary);
	  exit(1);
	}
    }
  else if (args->dictionary_home_given && args->language_given)
    {
      char buf[255];
      expand_path(args->dictionary_home_arg, buf);
      sprintf(dictionary,"%s/%s/lem.bin",buf,args->language_arg);
      if(file_accessible(dictionary)!=0)
	{
	  fprintf(stderr,"Cannot open the dictionary file: %s\nAborting.\n",dictionary);
	  exit(1);
	}
    }
}


// STARE
//  if(args.dictionary_given)
//    strcpy(dictionary, args.dictionary_arg);
//  else {
//     char path[256];
//     //sprintf(path, "/etc/utt/data/%s/%s", args.locale_arg, DICT_FILE);
//     //if (file_accessible(path) == 0)
//     //  strcpy(dictionary, path);
//     //else {
//       sprintf(path, "%s/%s", utt_dir, DICT_FILE);
//       if (file_accessible(path) == 0)
// 	strcpy(dictionary, path);
//       else {
// 	fprintf(stderr, "Cannot find dictionary!\n");
// 	exit(1);
//       }
//       //}
//   }

