
#include "mgraph.hh"
#include "thesymbols.hh"
#include "const.hh"

#include <stdio.h>

int MGraph::add_node(char* seg)
{
  nodes[n].clear();
  
  char field1[80], field3[80], descr[256], gph[256];
  char* cat;
  
  getfield(seg,"1",field1);
  nodes[n].pos=atoi(field1);

  getfield(seg,"3",field3);
  if(!getfield(seg,"lem",descr)) strcpy(descr,"?,?");

  cat=descr;
  while(*cat!=',' && *cat ) ++cat;
  if(*cat) ++cat;
  
  Cat::add(cat);
  nodes[n].cat=cat;
  
  nodes[n].pred.clear();
  
  char* tok;
  int previd;
  
  if(!getfield(seg,"gph",gph))
  {
    fprintf(stderr,"No gph field. Aborting (sorry).\n");
    exit(1);
  }

  char* ids=strtok(gph,":");
  if(n!=atoi(ids)){fprintf(stderr,"Invalid node id in line ?. Program aborted.\n"); exit(1); }
  
  char *preds;
  while(preds=strtok(NULL,","))
  {
    previd=atoi(preds);
    nodes[n].pred.push_back(&nodes[previd]);
  }

  return n++;
}

