#
# Default RPM header.
#
# START_RPM_STD_HEADER:


#
# RPM properties
#
%define _this_product     UAM Text Tools
%define _this_summary	  Some tools for text processing
%define _this_name        utt
%define _this_version	  %(cat ../common/version.def)
%define _this_release	  %(cat ../common/release.def)
%define _this_copyright   Adam Mickiewicz University, Poland

#
# We need some paths
#
# Directory with utt binaries
%define _UTT_DIST_DIR	%(pwd)
#Root directory in which utt will be installed
%define _UTT_DIR		/usr/local/%_this_name
#Directory for rpm
%define _RPM_ROOT	%_UTT_DIST_DIR/../rpm_root

#
# Default RPM header.
#
# END_RPM_STD_HEADER:
# --------------------------------------------------------------------

Summary:     %_this_summary
Name:        %_this_name
Version:     %_this_version
Release:     %_this_release
#Copyright:   %_this_copyright
License:	GPL
Group:       Development/Tools
URL:         http://utt.amu.edu.pl
Vendor:      Adam Mickiewicz University
BuildRoot:   %_RPM_ROOT
#BuildArch: 	 i586
# requirements for utt application
#AutoReq: no
#AutoReqProv: no

#Requires: 	 glibc >= 2.1.3
#Requires: 	 libgcc1 >= 3.0
#Requires: 	 libgcc >= 3.0
#Requires:    libstdc++6 >= 3.4.1
#Requires:    libstdc++ >= 3.4.1

%description
%(cat ../common/description.def)

%description -l pl
%(cat ../common/description.pl.def)


# -------------------------------------------------------------
# preparing sources for compilation
%prep

# source compilation
%build

# rpm building
%install
%__mkdir_p $RPM_BUILD_ROOT%_UTT_DIR
cp -fr %_UTT_DIST_DIR/* $RPM_BUILD_ROOT%_UTT_DIR/


# cleaning after rpm build
%clean
rm -rf $RPM_BUILD_ROOT

# -------------------------------------------------------------
#before installation
%pre


#after installation
%post
# we need to create utt.conf file
%_UTT_DIR/create_utt_config.pl
rm -f %_UTT_DIR/create_utt_config.pl
# we need to create links in /usr/local/bin
find %_UTT_DIR/bin/ -type f -exec ln -f {} /usr/local/bin \;


#before uninstallation
%preun
# we delete links from /usr/local/bin
for fn in `find %_UTT_DIR/bin/ -type f -exec basename {} \;`; do rm -f /usr/local/bin/$fn; done


#after uninstallation
%postun
# we remove all extra files
rm -fr %_UTT_DIR

# -------------------------------------------------------------
%files
%defattr(-,root,root)
/*
