#include <ctype.h>
#include <stdio.h>

inline
bool inline_matchattr(const char* a, const char* b)
{
  const char *p, *q; // pomocnicze wskazniki
  while(*a && *b)
  {
    p=a; q=b; 
    while(isupper(*p) && isupper(*q)) // rowny prefiks
      if(*p==*q) ++p, ++q;
      else if(*p<*q) // a jest mniejszy
      {
        // przesywamy a do nastepnego atr
        a=p;
        while(isupper(*a)) ++a; while(islower(*a)) ++a; 
        goto end;
      } 
      else
      {
        // przesuwamy b do nastepnego atr
        b=q;
        while(isupper(*b)) ++b; while(islower(*b)) ++b; 
        goto end;
      }

    if(islower(*p) && islower(*q)) // rowne atrybuty
    {
      a=p; b=q; // przesuwamy wskaznik, sprawdzamy wartosci
      while(*a != *b)
      {
        if(*a > *b && !islower(*++b)) return false;
        if(*a < *b && !islower(*++a)) return false;
      }
      // znaleziono rowna wartosc, przesywamy a i b do nast atr
      while(isupper(*a)) ++a; while(islower(*a)) ++a; 
      while(isupper(*b)) ++b; while(islower(*b)) ++b;
      goto end;
    }
 
    if(islower(*p)) // a jest krotszy, czyli mniejszy
    { // przesuwamy a do nastepnego atrybutu
      a=p;
      while(islower(*a)) ++a; 
      goto end;
    }

    if(islower(*q)) // b jest krotszy, czyli mniejszy
    { // przesuwamy b do nastepnego atrybutu
      b=q;
      while(islower(*b)) ++b; 
      goto end;
    }
  end: ;
  }
  return true;
}


bool matchattr(const char* a, const char* b)
{
  return inline_matchattr(a,b);
}

bool matchdescr(const char* a, const char* b)
{
  while(isupper(*a) && isupper(*b) && *a==*b) ++a, ++b;
  if(*a=='\0')
    if(*b=='\0' || *b=='/') return true;
    else return false;

  if(*a=='/')
    if(*b=='\0') return true;
    else if(*b=='/') return inline_matchattr(++a, ++b);

  return false;
}


int main()
{
  char a[100], b[100];
  while(scanf("%s %s", a, b)==2)
    printf("%s & %s = %d\n", a, b, matchdescr(a,b));
}
