#!/usr/bin/perl

use Cwd 'abs_path';
use File::Basename;
use POSIX;

my $cur_dir = dirname(abs_path($0));

open(FILE, ">$cur_dir/conf/utt.conf");

# we put some description into utt.conf file
print FILE "# ************************************************************\n";
print FILE "# * This file was created automatically during installation. *\n";
print FILE "# * If you don't need do not change it.                      *\n";
print FILE "# *                                                          *\n";
print FILE "# * UAM Text Tools                                           *\n";
print FILE "# * Adam Mickiewicz University, Poland                       *\n";
print FILE "# * http://utt.amu.edu.pl                                    *\n";
print FILE "# ************************************************************\n";
print FILE "\n\n";

# we need utt home directory
print FILE "# absolute path to utt directory\n";
print FILE "UTT_HOME=$cur_dir\n\n";


# we need user default locale
$best_locale = findLocale();
print FILE "# user locale\n";
print FILE "UTT_LOCALE=$best_locale\n";
print FILE "\n";

close FILE;



sub findLocale() {
	$cur_locale = setlocale(LC_CTYPE);

	# we replace Latinx to ISO-8859-x
	$cur_locale =~ s/(.+?)Latin(.+?)/$1ISO\-8859\-$2/g;

	if($cur_locale =~ /\w+_\w+\.\S+/) {
	  $best_locale = $cur_locale;
	}
	elsif($cur_locale =~ /\w+_\w+/) {
	  $best_locale = $cur_locale.".UTF-8";
	}
	else {
	  $best_locale = toupper($cur_locale).'_'.tolower($cur_locale).'.UTF-8';
	}
	return $best_locale;
}
