#include "auttools.h"
//#include "/src/cpp-comm/plx/Plx.h"

void fullform(const char* b, const char* d, char* f)
{
  int i,j=0;
  int n1, n2=0;
  bool g=false;
  char s1[200], s2[200], temps[200];
  while(d[j]>='0' && d[j]<='9')j++;
  strncpy(temps,d,j); temps[j]='\0';
  n1=atoi(temps);
  i=j;
  while(!ispunct(d[j]) || d[j]=='*') j++;
  strncpy(s1,d+i,j-i);
  s1[j-i]='\0';
  if(d[j++]=='-')
  {
    i=j;
    while(d[j]>='0' && d[j]<='9')j++;
    strncpy(temps,d+i,j-i); temps[j]='\0';
    n2=atoi(temps);
    i=j;
    while(!ispunct(d[j]) || d[j]=='*') j++;
    strncpy(s2,d+i,j-i);
    s2[j-i]='\0';
    g=true;
  }

  int blen=strlen(b);
  if(g)
    if(n1+n2<=blen)
    {
      strcpy(f,s1);
      strcat(f,b+n1);
      f[strlen(f)-n2]='\0';
      strcat(f,s2);
    }
    else
      strcpy(f,"<ERR>");
  else
    if(n1<=blen)
    {
      strcpy(f,b);
      f[strlen(f)-n1]='\0';
      strcat(f,s1);
    }
    else
      strcpy(f,"<ERR>");
}

void compose(char* stem, char* ending, char* form)
{
  bool suffix=true;
  while(*stem)
    if(*stem=='*')
    {
      strcpy(form,ending);
      form+=strlen(ending);
      suffix=false;
      stem++;
    }
    else
      *(form++)=*(stem++);
  if(suffix)
  {
    strcpy(form,ending);
    form+=strlen(ending);
  }
  *form='\0';
}

void autodescr(const char* f, const char* des, char* lemma, char* pos, char* attr)
{
  char lemd[MAXWORDLEN];
  int o,l=strcspn(des,",");
  strncpy(lemd,des,l);
  lemd[l]='\0';
  fullform(f,lemd,lemma);
  o=l+1;
  l=strcspn(des+o,"/:");
  strncpy(pos,des+o,l);
  pos[l]='\0';
  o=o+l;
  if(des[o]=='/')
  {
    o++;
    strcpy(attr,des+o);
  }
  else
    attr[0]='\0';
}


int common_prefix(const char* s, const char* t)
{
  int n=0;
  while(*s==*t && *s!='\0')
  { s++,t++;n++; }
  return n;
}

int strdiff(const char* s, const char* t,
            int& frontcut, char* prefix, int& endcut, char* suffix)
{
  int slen=strlen(s);
  int tlen=strlen(t);
  int ss, ss_max=0;                 /* ss - s shift */
  int ts, ts_max=0;                 /* ts - t shift */
  int common, common_max=0;
  for(ss=0;ss<slen;ss++)
    for(ts=0;ts<tlen;ts++)
      if( (common=common_prefix(s+ss,t+ts))>common_max
          && (common>4 || (ss==0 && ts==0 && common>1)) )
      {
        ss_max=ss;
        ts_max=ts;
        common_max=common;
      }
  //  print "--", tsmax,"\n"
  printf("--%d\n", ts_max);
  frontcut=ss_max;
  strncpy(prefix,t,ts_max); prefix[ts_max]='\0';
  endcut=slen-ss_max-common_max;
  strcpy(suffix,t+ts_max+common_max);
  return common_max;
}

void fprndiff(FILE* f, const char* s, const char* t)
{
  int frontcut,endcut;
  char pref[MAXWORDLEN],suff[MAXWORDLEN];
  strdiff(s,t,frontcut,pref,endcut,suff);
  if(frontcut!=0 || pref[0]!='\0')
    fprintf(f,"%d%s-%d%s",frontcut,pref,endcut,suff);
  else
    fprintf(f,"%d%s",endcut,suff);
}

void sprndiff(char* outstr, const char* s, const char* t)
{
  int frontcut,endcut;
  char pref[MAXWORDLEN],suff[MAXWORDLEN];
  strdiff(s,t,frontcut,pref,endcut,suff);
  if(frontcut!=0 || pref[0]!='\0')
    sprintf(outstr,"%d%s-%d%s",frontcut,pref,endcut,suff);
  else
    sprintf(outstr,"%d%s",endcut,suff);
}


void despos(const char* des, char* pos)
{
  int di=0;
  int pi=0;
  while(des[di]!=',' && des[di]!='\0') ++di;
  if(des[di]==',')
  {
    ++di;
    while(isupper(des[di])) pos[pi++]=des[di++];
  }
  pos[pi]='\0';
}

