#include "../lib/iotools.h"
#define _CMDLINE_FILE "../lem/cmdline.h"
#include "../common/common.h"
#include "common_lem.h"
#include "lem.h"
#include "cmdline.h"
#include <locale.h>

int main(int argc, char** argv) {

//   setlocale(LC_CTYPE,""); //PO CO TO?
//   setlocale(LC_COLLATE,""); //

  gengetopt_args_info args;

  if(cmdline_parser(argc, argv, &args) != 0)
    exit(1);

  process_config_files(&args,argv[0]);
  process_common_options(&args,argv[0]);
  process_lem_options(&args);
  
  char line[MAX_LINE+1];
  char outline[MAX_LINE+1];
  char parms[MAX_LINE+1], desc[MAX_LINE+1], lemma[MAX_LINE+1];
  long line_count = 0;

  Lem* lem;
  
  if(strcmp(dictionary+strlen(dictionary)-4,".bin")==0)
    lem = new Lem(dictionary);
  else if(strcmp(dictionary+strlen(dictionary)-4,".dic")==0)
    lem = new AuxLem(dictionary);
  else
    fprintf(stderr,"lem: Invalid dictionary file extension.\n");

  Words tab;
//   Segment seg;

  while (fgets(line, MAX_LINE, inputf))
    {
      //      strcpy(outline,line);
      ++line_count;

      int start, len;
      
      if (!process_seg(line, args)) // TO POWINNO BYC WCZESNIEJ ZABEZPIECZONE
	fputs(line, outputf);
      else
	{
	  char form[MAX_FORM];

	  tab.clear();
	  getfield(line,input_field_prefix,form);
	  if (form==NULL) continue;
	  
	  lem->ana(form, tab);
	  if(tab.count()==0)
	    {
	      char form1[MAX_FORM]; // tymczasowo tak, trzeba zmienic ana
	      char* p;
	      strcpy(form1,form);
	      for(p=form1;*p;++p) *p=tolower(*p);
	      p=form1;
	      lem->ana(p,tab);
	    }
	  
	  if (tab.count() == 0) 
	    fputs(line, failedf);
	  else 
	    { // mamy jakies opisy w slowniku
	      
	      if(one_line)
		{
		  char* descp=desc;
		  for (int i=0; i< tab.count(); ++i)
		    {
		      descp += sprintf(descp," %s%s,%s", output_field_prefix, tab[i].lemma(), tab[i].descr());
		    }
		  strcpy(outline,line);
		  outline[strlen(outline)-1]='\0';
		  strcat(outline,desc);
		  strcat(outline,"\n");
		  fputs(outline, outputf);
		  if (copy_processed)
		    fputs(line,outputf);
		}
	      else if(one_field)
		{
		  char* descp=desc;
		  for (int i=0; i< tab.count(); ++i)
		    if(i==0)
		      descp += sprintf(descp," %s%s,%s", output_field_prefix, tab[i].lemma(), tab[i].descr());
		    else
		      {
			if(strcmp(tab[i].lemma(),tab[i-1].lemma())==0)
			  descp += sprintf(descp,",%s",tab[i].descr());
			else
			  descp += sprintf(descp,";%s,%s",tab[i].lemma(),tab[i].descr());
		      }
		  
		  strcpy(outline,line);
		  outline[strlen(outline)-1]='\0';
		  strcat(outline,desc);
		  strcat(outline,"\n");
		  fputs(outline, outputf);
		  if (copy_processed)
		    fputs(line,outputf);
		}
	      else
		{
		  for (int i=0; i< tab.count(); ++i)
		    {
		      // kolejne opisy - kolejne linie.
		      sprintf(desc, " %s%s,%s\n", output_field_prefix, tab[i].lemma(), tab[i].descr());
		      strcpy(outline,line);
		      outline[strlen(outline)-1]='\0';
		      strcat(outline,desc);
		      fputs(outline, outputf);
		    }
		  if (copy_processed)
		    fputs(line,outputf);
		}
	    } 
	}
      
      if(args.interactive_flag) 
	fflush(outputf), fflush(failedf);
      
    }
  cmdline_parser_free(&args);
}
