//---------------------------------------------------------------------------
#ifndef _corr_hh
#define _corr_hh
//---------------------------------------------------------------------------

#include "../lib/tfti.h"
#include "../lib/word.h"

class Corr : public TFTiv<char,char>
{
private:
  int H[100][100];
  char X[100];                         // misspelled string
  char Y[100];                         // (possibly partial) candidate string
  int m;                               // length of X
  int n;                               // maximal length of Y

  int ed(int,int);
  int cuted(int);
  void recomputeH(int);

public:
  int (*H2)[100];

  int t;                               // threshold

  Corr() : H2((int(*)[100])&H[2][2]) {};
  Corr(const char* a) : TFTiv<char,char>(a), H2((int(*)[100])&H[2][2]) { };

  int correct(const char* w, Words& tab);
};

//---------------------------------------------------------------------------
#endif
