#! /usr/bin/perl

use locale;
use strict;

my $file = shift;
my $filename;

if ($file eq "") {
    print "Podaj nazw pliku.\n";
    exit(1);
}

if ($file =~ /(.*)\.dic/)
{
    $filename = $1;
}
else
{
    print "The input file must have .dic extension.";
    exit(1);
}

`makeLabels.pl > labels.sym`;

`lexmakelab labels`;

print "Kanonizuj opisy.........................................";

#`canon.pl <$file >temp2`;

print "Kompiluj automat........................................";

`lexcomplex -l labels.lab -S labels.scl <$file > temp1`;

print "OK\n";

print "Usuwam epsilon-przejscia.................................";

`fsmrmepsilon temp1> temp2`;

print "OK\n";

print "Determinizuj automat....................................";

`fsmdeterminize temp2 > temp1`;

print "OK\n";

print "Minimalizuj automat.....................................";

`fsmminimize temp1> temp2`;

print "OK\n";

print "Konwertuj automat do formatu fsa........................";

`fsmprint -i labels.lab temp2> temp1`;

`cp temp1 pofsmprint`;

`../fsm2aut temp1> temp2`;

`./aut2fsa.nowy < temp2> $filename.bin`;

print "OK\n";

print "Czyszcz pliki pomocnicze................................";

`rm temp2`;
`rm temp1`;
#`rm labels.*`;

print "OK\n";

