#! /usr/bin/perl

use locale;

$linesPerFile = 20000;

if (@ARGV < 1) {
    print "usage: prep.pl dictionary_file\n";
    exit;
}

$file = shift; # @ARGV;
$kind = shift;

if ($kind eq "") {
    $kind="suf";
}

# Przygotowanie etykiet

`makeLabels.pl > labels.sym`;

`lexmakelab labels`;

# Analiza pliku sownika


print "Kanonizuj opisy.........................................";

`canon.pl <$file >temp2`;

print "OK\n";

print "Analizuje prefiksy.......................................";

`count_prefs.pl 2 4 < temp2 > prefs`;
`sort -k1,1 -k3,3nr prefs > prefsS`;
`cut_prefs.pl 0.5 0.01 100 prefsS > prefs`;
`rm prefsS`;

print "OK\n";

print "Analizuj plik sownika";

if ($kind eq "pre") {
    print "(pre).............................";
    `stat_pre.pl temp2 > temp1`;
} else {
    print "(suf).............................";
    `stat.pl prefs < temp2 > temp1`;
}

print "OK\n";

# zmniejszamy plik...

print "Sortuj plik.............................................";

`sort -t \\~ -k1,1 -k2,2nr <temp1 > temp2`;

print "OK\n";

print "Minimalizuj plik sownika...............................";

`rmDup.pl < temp2 > temp1`;
#`rmDup2.pl < temp1 > temp2`;

`cp temp1 temp2`;

`rm temp1`;

print "OK\n";

#dzielimy plik na wiele czci, uruchamiamy lexcomplex dla kadej
#czci osobno, nastpnie czymy to za pomoc programu fsmunion

print "Dziel sownik na mniejsze czci........................";

open(IN, "./temp2");

$lineCount = 0;
$fileCount = 0;

`mkdir LemTEMP`;

open(FILE, ">LemTEMP/slo_0");

while (<IN>) {

    if (++$lineCount >= $linesPerFile) {
	$fileCount++;
	$lineCount = 0;

	close(FILE);
#	print "Tworz nowy plik tymczasowy: slo_".$fileCount."\n";
	open(FILE, ">LemTEMP/slo_".$fileCount);
    }

    print(FILE $_);
}

print "OK\n";

print "Tworz automaty porednie";

#32 kropki, fileCount plikow
$filesPerDot = $fileCount/32;
$files=$filesPerDot;
$dots=0;

for ($i=0; $i<=$fileCount; $i++) {

    if ($files >= $filesPerDot) {
	$files = 0;
	print ".";
	$dots++;
    }
    $files++;

    $command = "lexcomplex -l labels.lab -S labels.scl < LemTEMP/slo_".$i." > LemTEMP/slownik_".$i.".fsm";

    `$command`;

}
if ($dots < 32) {
    for ($i=0; $i<32 - $dots; $i++) {
	print ".";
    }
}

print "OK\n";

`rm LemTEMP/slo_*`;

print "Tworz automat kocowy";

#35 kropek...
$filesPerDot = $fileCount/35;
$files=$filesPerDot;
$dots=0;

`cp LemTEMP/slownik_0.fsm slownik1.fsm`;

for ($i=1; $i<=$filecount; $i++) {

    if ($files >= $filesPerDot) {
	$files = 0;
	print ".";
	$dots++;
    }
    $files++;

    $command = "fsmunion LemTEMP/slownik_".$i." slownik1.fsm > slownik2.fsm";

    `$command`;

    `mv slownik2.fsm slownik1.fsm`;
}

if ($dots < 35) {
    for ($i=0; $i<35 - $dots; $i++) {
	print ".";
    }
}

`fsmunion LemTEMP/* > slownik1.fsm`;

print "OK\n";

print "Usuwam epsilon-przejscia.................................";

`fsmrmepsilon slownik1.fsm > slownik2.fsm`;

`rm slownik1.fsm`;

print "OK\n";

print "Determinizuj automat....................................";

`fsmdeterminize slownik2.fsm > slownik1.fsm`;

`rm slownik2.fsm`;

print "OK\n";

print "Minimalizuj automat.....................................";

`fsmminimize slownik1.fsm > slownik.fsm`;

`rm slownik1.fsm`;

print "OK\n";

print "Konwertuj automat do formatu fsa........................";

`fsmprint -i labels.lab slownik.fsm > slownik.txt`;

`../fsm2aut slownik.txt > slownik.aut`;

`../aut2fsa < slownik.aut > gue.bin`;

print "OK\n";

print "Czyszcz pliki pomocnicze................................";

`rm LemTEMP/*`;
`rmdir LemTEMP`;
`rm temp2`;
`rm slownik.fsm`;
`rm slownik.txt`;
`rm slownik.aut`;

print "OK\n";
