#ifndef __COMMON_H
#define __COMMON_H

#include <stdio.h>
#include <ctype.h>

#include "cmdline.h"
#include "const.hh"


/**************************************************
 * Stale dotyczace wejscia/wyjscia
 */

#define EMPTYFORM '*'
#define INFIELD_SEP ':'
#define MAXAUX 64
#define FIELD_SEP " \t\n"

/**************************************************/


extern FILE* inputf;
extern FILE* outputf;
extern FILE* failedf;

extern char* input_filename;
extern char* output_filename;
extern char* failed_filename;

extern bool copy_processed;
extern bool append_output;
extern bool append_failed;

extern void process_common_options(gengetopt_args_info args);



/**************************************************/
/*
parameters:
  -seg  - segment
  -name - field name
  +val  - field contents
return value:
  1 if specified field exists, 0 otherwise
*/

inline int getfield(const char* seg, const char* pref, char* val)
{
  const char* p=seg;

  while(*p==' ') ++p;
  
 pos:
  if(isdigit(*p) or *p=='*')
    if(*pref=='1') return sscanf(p,"%s",val); else while(*p!=' ') ++p; 
  else
    if(*pref=='1') return 0; else goto type;

  while(*p==' ') ++p;
  
 len:
  if(isdigit(*p) or *p=='*')
    if(*pref=='2') return sscanf(p,"%s",val); else while(*p!=' ') ++p; 
  else
    if(*pref=='2') return 0; else goto type;

  while(*p==' ') ++p;
  
 type:

  if(*pref=='3') return sscanf(p,"%s",val); else while(*p!=' ') ++p;

  while(*p==' ') ++p;

 form:
  if(*pref=='4') return sscanf(p,"%s",val); else while(*p!=' ') ++p;

  while(*p==' ') ++p;

 annotation:
  do p=strstr(p,pref); while(p!=NULL && *(p-1)!=' ' && *(p-1)!='\t');
  
  if(p==NULL) return 0;
  else
  {
    p+=strlen(pref);
    int len=strcspn(p,FIELD_SEP "\n\r\f\0");
    strncpy(val,p,len);
    val[len]='\0';
    return 1;
  }
}


/*
parameters:
  +seg - segment
  -pref - prefix of the new field
  -val  - contents of the new field
return value:
  1 - success, 0 - fail (limit on segment length exceeded)
*/
inline int addfield(char *seg, const char *pref, const char *val)
     // zalozenie, ze seg konczy sie znakiem \n
{
  if(strlen(seg)+strlen(pref)+strlen(val) >= MAXLINE) return 0; // bezpieczniej, ale wolniej

  int seglen=strlen(seg);
  sprintf(seg+(seglen-1)," %s%s\n",pref,val);
  return 1;
}


inline
bool processseg(const char* s, gengetopt_args_info& args)
{
  bool ret = !args.process_given;
  char field[MAXAUX];
    
  if(args.process_given)
  {
    getfield(s,"3",field);
    for(int i=0; i<args.process_given; ++i)
      if(strcmp(args.process_arg[i],field)==0)
      {
        ret=true;
        break;
      }
  }

  for(int i=0; i<args.select_given; ++i)
    if(! getfield(s,args.select_arg[i],field))
      ret=false;
  
  for(int i=0; i<args.ignore_given; ++i)
    if(getfield(s,args.ignore_arg[i],field))
      ret=false;

  return ret;
}


/* DEPRICATED */


/* definicja struktury wejscia/wyjscia
 */
struct Segment
{
  int filepos, len;
  char* tag;
  char* form;
  char* aux[MAXAUX];
  int auxn;

  bool parse(char* line);
  char* getfield(char* fieldname);
  void print(char* line);
  bool addfield(char* s);
  bool clearfields();
};

/*
 * Sprawdza czy nalezy przetwarzac dany segment.
 */

inline
bool process_seg(Segment& s, gengetopt_args_info& args)
{
  bool ret = !args.process_given;

  for(int i=0; i<args.process_given; ++i)
    if(strcmp(args.process_arg[i],s.tag)==0)
      {
        ret=true;
        break;
      }

  for(int i=0; i<args.select_given; ++i)
    if(! s.getfield(args.select_arg[i]))
      ret=false;

  for(int i=0; i<args.ignore_given; ++i)
    if(s.getfield(args.ignore_arg[i]))
      ret=false;

  return ret;
}


/*
 * FUNKCJE OBSLUGUJACE WEJSCIE/WYJSCIE
 */
// napisy zostaj na miejscu (w line), tylko wskazniki sa ustawian
// i zara dopisywane zera s dopisywane

inline
bool Segment::parse(char* line)
{
  auxn=0;
  char* field;
  if((field=strtok(line,FIELD_SEP))!=NULL)
    filepos=atoi(field); // nie sprawdzana poprawnosc
  else
    return false;
  if((field=strtok(NULL,FIELD_SEP))!=NULL)
    len=atoi(field); // nie sprawdzana poprawnosc
  else return false;
  if((tag=strtok(NULL,FIELD_SEP))==NULL) return false;
  if((form=strtok(NULL,FIELD_SEP))==NULL)
    return false;
/*   else */
/*     if(form[0] == EMPTYFORM && form[1] =='\0') */
/*       form=NULL; */

  while((aux[auxn]=strtok(NULL,FIELD_SEP))!=NULL) ++auxn;

  return true;
}


inline char* Segment::getfield(char* f)
{
  int flen=strlen(f);
  for(int i=0; i<auxn; ++i)
    if(strncmp(aux[i],f,flen)==0 && aux[i][flen]==INFIELD_SEP)
      return aux[i]+flen+1;
  return NULL;
}

inline bool Segment::clearfields() {
  for (int i=0; i<auxn; ++i) {
    //    free(aux[i]);
    aux[i] = NULL;
  }
  auxn=0;
  return true;
}

inline // NIEEFEKTYWNE
void Segment::print(char* line)
{
  sprintf(line,"%04d %02d %s", filepos, len, tag);
  if(form)
    {
      strcat(line," ");
      strcat(line,form);
    }
  else
    if(auxn)
      strcat(line," *");

  for(int i=0; i<auxn; ++i)
    {
      strcat(line," ");
      strcat(line,aux[i]);
    }

  strcat(line,"\n");
}


inline
bool Segment::addfield(char* s)
{
  if(auxn<MAXAUX)
    {
      aux[auxn++]=s;
      return true;
    }
  else
    return false;
}

#endif
